package com.elitesland.sale.api.service;


import com.elitesland.sale.api.vo.param.crm.*;
import com.elitesland.sale.api.vo.resp.crm.*;
import com.elitesland.sale.api.vo.resp.sal.RmiOuDetailVO;
import com.elitesland.sale.api.vo.resp.sal.RmiOuInfoByAddr;
import com.elitesland.sale.api.vo.save.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.ComSearchParam;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
public interface CrmCustService {

    /**
     * 客户数据检查
     *
     * @param
     * @return 客户信息
     */
    //  ApiResult<List<CheckCustResVO>> checkCustData(CheckCustParamVO param);
    /**
     * 查询上级经销商信息
     */
    CustPrentInfoDTO getPrentCustByCode(String custCode);
    /**
     * 搜索客户信息
     *
     * @param searchParam 搜索参数
     * @return 客户信息
     */
    ApiResult<PagingVO<CrmCustSimpleVO>> query(ComSearchParam searchParam);
    List<CrmCustSimpleVO> queryCustList(CustListParam searchParam);
    PagingVO<CustBelongOuVO> belongOuPage(CustBelongOuPageParam param);

    /**
     * 查询客户详情数据
     *
     * @param id 数据id
     * @return 客户详情数据
     */
    CrmCustDetailRespVO get(Long id);

    CrmCustDetailRespVO getByCode(String custCode);


    List<CrmCustBaseRespVO> getByAgentEmpId(Long agentEmpId);


    /**
     * 分页查询搜索客户信息
     *
     * @param searchParam 搜索参数
     * @return 客户信息
     */
    PagingVO<CrmCustPageRespVO> search(CrmCustQueryParamVO searchParam);

    /**
     * 搜索客户弹框选择
     *
     * @param searchParam 搜索参数
     * @return 客户信息
     */
    ApiResult<PagingVO<CrmCustPlugInRespVO>> queryCustPlugIn(CrmCustPlugInParamVO searchParam);


    PagingVO<CustSalePredictionVO> queryCustSalePrediction(CustPredictionParamVO param);

    /**
     * 分页查询搜索客户信息
     *
     * @param searchParam 搜索参数
     * @return 客户信息
     */
    List<CrmCustPageRespVO> searchList(CrmCustQueryParamVO searchParam);

    /**
     * 保存数据
     *
     * @param saveVO 数据对象
     * @return 数据ID
     */
    ApiResult<CrmCustDetailRespVO> saveLm(CrmCustSaveVO saveVO);

    List<LmSaveCustRespVO> getCustInfoByRegion(List<String> region);

    /**
     * 保存数据
     *
     * @param saveVO 数据对象
     * @return 数据ID
     */
    ApiResult<CrmCustDetailRespVO> save(CrmCustSaveVO saveVO);

    /**
     * 保存数据
     *
     * @param saveVO 数据对象
     * @return 数据ID
     */
    ApiResult<CrmCustDetailRespVO> bcSave(CrmCustSaveVO saveVO);


    ApiResult<Object> updateAgentEmpId(List<CustImportEmpDTO> datas);


    /**
     * 启用禁用方法
     *
     * @param paramVO 客户启用禁用入参
     */
    void switchStatusByIds(CustSwitchStatusParamVO paramVO);

    /**
     * 客户信息导入接口
     *
     * @param parseData 客户信息集合
     * @return void
     */
    ApiResult<List<CrmCustImportSaveVO>> custImportData(List<CrmCustImportSaveVO> parseData);

    /**
     * 客户地址导入接口
     *
     * @param parseData 客户地址信息集合
     * @return void
     */
    ApiResult<List<CrmAddrImplSaveVO>> custaddrImportData(List<CrmAddrImplSaveVO> parseData);

    /**
     * 批量分配业务员
     *
     * @param crmEmpAssignParamVO crmEmpAssignParamVO
     */
    void empAssign(CrmEmpAssignParamVO crmEmpAssignParamVO);

    /**
     * 通过参数查询客户地址信息
     *
     * @param crmCustAddrParamVO 客户地址查询参数
     */
    List<CrmCustAddrRespVO> findAddrsByParam(CrmCustAddrParamVO crmCustAddrParamVO);


    /**
     * 通过客户编码精确查询客户是否存在
     *
     * @param custCode 公司编码
     */
    Boolean findCustByCode(String custCode);

    /**
     * 通过客户编码精确查询客户地址
     *
     * @param custCode 客户编码
     */
    List<CrmCustAddrRespVO> findAddrsByCustCode(String custCode);

    /**
     * 客户为大B但是没有ERP客户编码的
     *
     * @param searchParam
     * @return
     */
    PagingVO<CrmCustSimpleVO> checkQuery(CrmCustCheckParamVO searchParam);

    /**
     * 获取Mdm外部编码
     * @param taxRegNo
     * @return
     */
    //  String getMdmCustCode(String taxRegNo);

    /**
     * 根据地址号获取公司信息列表
     *
     * @param addrNo 地址号
     * @return 信息
     */
    RmiOuInfoByAddr getOuByAddr(Long addrNo);

    /**
     * 根据Code获取公司详细信息
     *
     * @param ouCode 编码
     * @return 信息
     */
    RmiOuDetailVO getOuByCode(String ouCode);

    Object updateContactPhone(CrmCustFixPhoneParamVO crmCustFixPhoneParamVO);

    /**
     * 对接七陌展示公司客户主数据
     *
     * @param custDto
     * @return
     */
    SevenCustVo select(SevenCustDto custDto, String token, String tokenId);

    List<CrmCustAddrRespVO> queryCustAddr();

    Long saveCustAddr(OrgAddrAddressSaveParam addr);

    void delCustAddr(Long id);

    CrmCustDetailRespVO getByUserName(String userName);

    CrmCustDetailRespVO getByUserId(Long userId);

    /**
     * 根据客户查区域
     *
     * @param custCode
     * @return
     */
    String getRegionByCustCode(String custCode);

    String getcustStatusByCode(String custCode);

    LmSaveCustRespVO getCustInfoByCustCode(String cust);


    List<LmSaveCustRespVO> getCustInfoByParam(CustAddrFindParam param);

    CrmCustSimpleVO getCustSimple(String userName);

    CrmCustSimpleVO getCustSimpleByUserId(Long userId);

    List<LmSaveCustRespVO> getCustInfoByPid(String Pid);

    List<LmSaveCustRespVO> getCustInfoByCustCodes(List<String> custCodes);

    List<LmSaveCustRespVO> getCustInfoByCustCode2s(List<String> custCode2s);


    List<LmSaveCustRespVO> getCustSimpleByParam(CrmCustSimpleParam param);

    PagingVO<CrmCustBasePageVO> getCustBasePage(CrmCustBaseParamVO crmCustBaseParamVO);

    ApiResult<Object> syncSyncToOu(List<Long> id);

    /**
     * 查询客户相信信息
     *
     * @param id 参数为custId
     * @return
     */
    CrmCustDetailRespVO getCustDetail(Long id);

    PagingVO<CrmCustPageRespVO> pageSearch(CrmCustQueryParamVO param);

    List<CrmCustReceiveAddrRespVO> queryCustReceiveAddr();

    Long saveReceiveAddr(ReceiveAddressSaveParam param);

    List<CustOuBuRespVO> getCustListByParam(CustOuBuParamVO custOuBuParamVO);

    ApiResult<Object> importCrmCust(List<CrmCustImportVO> list);

    ApiResult<Object> importCrmSubCust(List<CrmSubCustImportVO> list);

    ApiResult<Object> importCrmMajorCust(List<CrmMajorCustImportVO> list);

    List<CrmCustAddrRespVO> queryCustByAddrNo(Long addrNo);

    List<CrmCustReceiveAddrRespVO> queryCustReceiveByAddrNo(Long addrNo);

    List<DeliveryListRespVO> getDeliveryList(String custCode);

    String getAgentEmpCodeByCustCode(String custCode);

    PagingVO<CrmCustPageRespVO> subExportSearch(CrmCustQueryParamVO searchParam);

    void createAccount(List<Long> ids, boolean asyncFlag);
}
