package com.elitesland.sale.api.vo.resp.crm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/4 13:46
 */
@ApiModel(description = "客户信息")
@Data
public class CrmScustPageRespVO implements Serializable {
    private static final long serialVersionUID = 7101976805771412669L;

    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "潜在客户编码")
    private String custCode;

    @ApiModelProperty(value = "CRM客户编码")
    private String custCode2;

    @ApiModelProperty(value = "潜在客户名称")
    private String custName;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouName;

    @ApiModelProperty(value = "经销商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    private String buName;

    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "简称")
    private String custAbbr;

    @ApiModelProperty(value = "客户联系人")
    private String contPerson;

    @ApiModelProperty(value = "客户联系人电话")
    private String mobile;

    @ApiModelProperty(value = "客户联系人邮箱")
    private String email;

    @ApiModelProperty(value = "客户联系人详细地址")
    private String detailAddr;

    @ApiModelProperty(value = "客户联系人详细地址")
    private String addrDetail;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "财务属性 [UDC]CRM:FINANCIAL_ATTRIBUTE")
    @SysCode(sys = "yst-sale", mod = "FINANCIAL_ATTRIBUTE")
    private String financialAttribute;
    private String financialAttributeName;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "客户分类 [UDC]yst-sale:CUST_TYPE")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    private String custTypeName;

    @ApiModelProperty(value = "客户状态 [UDC]yst-sale:CUST_STATUS")
    @SysCode(sys = "yst-sale", mod = "SCUST_STATUS")
    private String custStatus;
    private String custStatusName;

    @ApiModelProperty(value = "客户行业 [UDC]COM:INDUSTRY")
    @SysCode(sys = "yst-supp",mod = "INDUSTRY")
    private String custIndustry;
    private String custIndustryName;

    @ApiModelProperty(value = "客户来源 [UDC]yst-sale:CUST_SOURCE")
    @SysCode(sys = "yst-sale", mod = "CUST_SOURCE")
    private String custSource;
    private String custSourceName;

    @ApiModelProperty(value = "意向等级 [UDC]yst-sale:SCUST_INTENT_LEVEL")
    @SysCode(sys = "yst-sale", mod = "SCUST_INTENT_LEVEL")
    private String intentLevel;
    private String intentLevelName;

    @ApiModelProperty(value = "最近跟进日期")
    private LocalDateTime lastFollowupDate;

    @ApiModelProperty(value = "区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "业务员")
    private Long agentEmpId;
    private String agentEmpName;

    @ApiModelProperty(value = "客户规模 [UDC]CRM:CUST_SCALE")
    @SysCode(sys = "yst-sale", mod = "CUST_SCALE")
    private String compScale;
    private String compScaleName;


    @ApiModelProperty(value = "年销售额")
    private String compTurnover;

    @ApiModelProperty(value = "操作")
    private String operation;

    @ApiModelProperty(value = "是否为燃气用户")
    private String es2;


}
