package com.elitesland.sale.api.vo.param.contract;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 分页查询参数 - 项目合同分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-07 20:16:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "销售合同分页查询请求参数")
public class SaleContractItemPagingParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 3507394458368618364L;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同id列表")
    private List<Long> contractIdList;
    @ApiModelProperty("合同号")
    private String contractNo;
    @ApiModelProperty("物料ID")
    private Long itemId;

    @ApiModelProperty("付款协议类型")
    private String protocolType;
    @ApiModelProperty("付款协议编码")
    private String protocolCode;


}
