package com.elitesland.sale.api.service.shop;

import com.elitesland.sale.api.vo.param.shop.app.BipItemAppQueryParamVO;
import com.elitesland.sale.api.vo.param.shop.app.BipItemRecommendAppQueryParamVO;
import com.elitesland.sale.api.vo.resp.shop.app.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * app端专用商品服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/30
 */
public interface BipItemAppService {

    /**
     * app端搜索商品列表
     *
     * @param queryParamVO 查询参数
     * @return 商品列表
     */
    ApiResult<PagingVO<BipItemListAppRespVO>> queryForApp(BipItemAppQueryParamVO queryParamVO);

    /**
     * 首页轮播图中根据满减code查询商品
     * @param offsetCode 满减code
     * @return 商品信息
     */
    ApiResult<List<BipItemListAppRespVO>> rotationItem(String offsetCode);

    /**
     * app端商品推荐
     *
     * @param queryParamVO 查询参数
     * @return 商品列表
     */
    ApiResult<List<BipItemRecommendAppRespVO>> queryForAppRecommend(BipItemRecommendAppQueryParamVO queryParamVO);

    /**
     * app端热销商品
     *
     * @param ouId 公司id
     * @return 商品列表
     */
    ApiResult<PagingVO<BipItemHotAppRespVO>> queryForAppHot(Long ouId);

    /**
     * app端精品推荐
     *
     * @param ouId 选择的公司
     * @param size 推荐数量，默认10
     * @return 商品列表
     */
    ApiResult<List<BipItemRecGoodAppRespVO>> queryForRecGood(Long ouId, Integer size);

    /**
     * app端获取商品详情
     *
     * @param id 商品ID
     * @return 商品详情
     */
    ApiResult<BipItemDetailAppRespVO> getDetail(Long id,Long ouId);

    /**
     * 获取商品的SKU信息
     *
     * @param id 商品ID
     * @return sku信息
     */
    ApiResult<BipItemAttrAppRespVO> getItemSku(Long id);

    /**
     * 查询收获地址
     *
     * @return 收获地址
     */
    ApiResult<List<BipReceiptAddrAppRespVO>> queryReceiptAddr();


    /**
     * 支付成功更新商品销量
     */
    void updateItemSalNumAll(String docNo);
}
