package com.elitesland.sale.api.vo.param.pro;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 分页查询参数 - 项目合同分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-07 20:16:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "项目合同分页查询请求参数")
public class SalContractPagingParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 3507394458368618364L;

    @ApiModelProperty("ID")
    private List<Long> ids;

    @ApiModelProperty(value = "合同编码")
    private String contractNo;

    @ApiModelProperty(value = "合同名称")
    private String contractName;

    @ApiModelProperty(value = "合同分类")
    private String contractType;

    @ApiModelProperty(value = "签约日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;

    @ApiModelProperty(value = "项目名称")
    private String projName;

    @ApiModelProperty(value = "合同状态")
    private String contractStatus;

    @ApiModelProperty("签约客户")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("签约公司")
    private String signOu;

    @ApiModelProperty("销售员")
    private String salesMan;

    @ApiModelProperty("客户类别")
    private String custType;

    @ApiModelProperty("区域")
    private String region;

    // 根据客户类别反查出的客户ID集合
    private List<Long> custIds;

    @ApiModelProperty("是否查询未激活合同单 true:查(默认查),false:不查")
    private String findCloseOrderFlag;

}
