package com.elitesland.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.Application;
import com.elitesland.sale.api.vo.param.contract.SaleContractSaveParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 知原药业销售合同rpc接口
 *
 * @since 2025-09-25 14:46
 */
@FeignClient(name = Application.NAME, path = SaleContractRpcService.URI)
public interface SaleContractRpcService {
    String URI = Application.URI_PREFIX + "/saleContract";

    /**
     * 新增修改销售合同
     * id为null是新增，否则是修改
     *
     * @param param
     * @return
     */
    @GetMapping("/save")
    ApiResult<Long> save(@RequestBody SaleContractSaveParam param);

}