package com.elitesland.sale.api.vo.resp.salesman;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Danny.Wang
 * @title SalesmanExportVO
 * @Date2023/2/23 17:57
 */
@Data
@ApiModel("业务员数据导出参数")
public class SalesmanExportVO implements Serializable {
    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("业务员类型")
    private String salesmanType;

    @ApiModelProperty("管辖区域")
    private String jurisdiction;

    @ApiModelProperty("登录账号")
    private String loginAccount;

    @ApiModelProperty("上级业务员名称")
    private String masSalesmanName;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("性别")
    private String sex;

    @ApiModelProperty("出生日期")
    private LocalDateTime birthdayTime;

    @ApiModelProperty("身份证号")
    private String idCardNo;

    @ApiModelProperty("省")
    private String province;

    @ApiModelProperty("市")
    private String city;

    @ApiModelProperty("区")
    private String area;

    @ApiModelProperty("详细地址")
    private String detailedAddress;

    @ApiModelProperty("入职日期")
    private LocalDateTime joinTime;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("组织名称")
    private String buName;

    @ApiModelProperty("启用状态")
    private String enableStatus;
}
