package com.elitesland.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.Application;
import com.elitesland.sale.api.vo.param.contract.*;
import com.elitesland.sale.api.vo.resp.contract.SaleContractItemRpcVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 知原药业销售合同rpc接口
 *
 * @since 2025-09-25 14:46
 */
@FeignClient(name = Application.NAME, path = SaleContractRpcService.URI)
public interface SaleContractRpcService {
    String URI = Application.URI_PREFIX + "/saleContract";

    /**
     * 新增修改销售合同
     * id为null是新增，否则是修改
     *
     * @param param
     * @return
     */
    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody SaleContractSaveParam param);

    /**
     * 检验销售合同明细已执行数量
     *
     * @param params
     * @return
     */
    @PostMapping("/checkContractExecutedQty")
    ApiResult<String> checkContractExecutedQty(@RequestBody List<SaleContractItemCheckParam> params);
    /**
     * 修改销售合同明细已执行数量和合同状态
     *
     * @param params
     * @return
     */
    @PostMapping("/updateContractExecutedQty")
    ApiResult<Object> updateContractExecutedQty(@RequestBody List<SaleContractItemCheckParam> params);

    /**
     * 获取销售合同价格
     *
     * @param param
     * @return
     */
    @PostMapping("/getSaleContractPrice")
    ApiResult<List<SaleContractItemRpcVO>> getSaleContractPrice(@RequestBody SaleContractItemPagingParam param);

}