package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @auther JinXK
 * @date 2021/6/12 15:25
 */
@Data
@ApiModel(description = "销售收款明细参数(通用)")
public class SalReceiptdRespVO implements Serializable {
    private static final long serialVersionUID = -6618531965109486809L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "订单ID")
    private Long soId;

    @ApiModelProperty(value = "订单编号")
    private String soNo;

    @ApiModelProperty(value = "销售订单明细ID")
    private Long soDId;

    @ApiModelProperty(value = "行号")
    private BigDecimal soLineNo;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编号")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

//    @ApiModelProperty(value = "商品名称2")
//    private String itemName2;

    @ApiModelProperty(value = "商品规格")
    private String itemSpec;

    @ApiModelProperty(value = "品牌")
    private String itemBrand;

    @ApiModelProperty(value = "品牌名称")
    private String itemBrandName;

    @ApiModelProperty(value = "数量")
    private BigDecimal soQty;

    @ApiModelProperty(value = "单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String soUom;
    private String soUomName;

    @ApiModelProperty(value = "税率编号")
    private String soTaxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal soTaxRate;

    @ApiModelProperty(value = "税额")
    private BigDecimal soTaxAmt;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal soAmt;

    @ApiModelProperty(value = "本次收款金额")
    private BigDecimal receiptAmt;

    @ApiModelProperty(value = "本次收款税额")
    private BigDecimal receiptTax;

    @ApiModelProperty(value = "已红冲金额")
    private BigDecimal offedAmt;

    @ApiModelProperty(value = "红冲中金额")
    private BigDecimal offingAmt;

    @ApiModelProperty(value = "相关单据ID")
    private Long relateDocId;

    @ApiModelProperty(value = "相关单据明细ID")
    private Long relateDocDId;

    @ApiModelProperty(value = "本次收款不含税金额")
    private BigDecimal receiptNetamt;

    @ApiModelProperty(value = "相关单据编号 原始单号")
    private String relateDocNo;

    @ApiModelProperty(value = "对账单ID")
    private Long soaId;

    @ApiModelProperty(value = "对账单明细ID")
    private Long soaDetailId;

    @ApiModelProperty(value = "对账单编号")
    private String soaNo;

    @ApiModelProperty(value = "发货单明细ID")
    private Long dodId;

    @ApiModelProperty(value = "发货单编号")
    private String doDocNo;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("合同id")
    private Long contractId;

    @ApiModelProperty("合同code")
    private String contractCode;

    @ApiModelProperty("合同名称")
    private String contractName;

    /**反查字段**/
    @ApiModelProperty("已支付金额")
    private BigDecimal payedAmt;
    @ApiModelProperty("待付款金额")
    private BigDecimal openAmt;
    @ApiModelProperty("签收含税金额")
    private BigDecimal confirmAmt;
    @ApiModelProperty("应收款余额")
    private BigDecimal apAmt;
    @ApiModelProperty("申请退货数量")
    private BigDecimal qty;
    @ApiModelProperty("实际退货数量")
    private BigDecimal confirmQty;
    @ApiModelProperty("申请退货金额(含税)")
    private BigDecimal amt;
    @ApiModelProperty("批准退款金额")
    private BigDecimal refundAmt;
    @ApiModelProperty("退款中金额")
    private BigDecimal payingAmt;
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    @ApiModelProperty("未含税单价")
    private BigDecimal netPrice;
    @ApiModelProperty(value = "单据类型")
    private String docCls;

    @ApiModelProperty("红冲金额")
    private BigDecimal offAmt;
    @ApiModelProperty("红冲税额")
    private BigDecimal offTax;
}
