package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/26
 */
@Data
@ApiModel(description = "商品审批")
public class BipItemApproveSaveVO implements Serializable {
    private static final long serialVersionUID = -562985110554273507L;

    @ApiModelProperty(value = "商品记录ID", required = true, position = 1)
    @NotEmpty(message = "请选择审批的商品")
    private List<Long> idList;

    @ApiModelProperty(value = "是否审批通过", required = true, position = 2)
    @NotNull(message = "未知是否审批通过")
    private Boolean pass;

    @ApiModelProperty(value = "审批意见", position = 3)
    @Size(max = 500, message = "审批意见内容的长度限制为500")
    private String opinion;

    @ApiModelProperty(value = "审批人ID", position = 4)
    @NotNull(message = "未知审批人")
    private Long approverId;

    @ApiModelProperty(value = "审批人姓名", position = 5)
    @NotBlank(message = "未知审批人")
    @Size(max = 64, message = "审批人姓名的长度限制为64")
    private String approverName;
}
