package com.elitesland.sale.api.vo.save;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


@Data
public class AllowShipSaleImportVO implements Serializable {
    private static final long serialVersionUID = 3696410767495635209L;

    @ApiModelProperty(value = "客户组编码")
    @ExcelProperty(index = 0)
    private String custGroupCode;

    @ApiModelProperty(value = "客户组名称")
    @ExcelProperty(index = 1)
    private String custGroupName;


    @ApiModelProperty("客户编码")
    @ExcelProperty(index = 2)
    private String custCode;


    @ApiModelProperty("客户名称")
    @ExcelProperty(index = 3)
    private String custName;


    @ApiModelProperty("商品组编码")
    @ExcelProperty(index = 4)
    private String itemGroupCode;


    @ApiModelProperty("商品编码")
    @ExcelProperty(index = 5)
    private String itemCode;


    @ApiModelProperty("允发期编码")
    @ExcelProperty(index = 6)
    private String ruleCode;

    @ApiModelProperty("允发期名称")
    @ExcelProperty(index = 7)
    private String ruleName;

    @ApiModelProperty("生效时间字符串")
    @ExcelProperty(index = 8)
    @DateTimeFormat(pattern = "yyyy/MM/dd")
    private String validFromTimeStr;

    @ApiModelProperty("失效时间字符串")
    @ExcelProperty(index = 9)
    @DateTimeFormat(pattern = "yyyy/MM/dd")
    private String validToTimeStr;

    @ApiModelProperty("失效时间")
    private LocalDate validFromTime;

    @ApiModelProperty("失效时间")
    private LocalDate validToTime;


}
