//package com.elitesland.sale.api.service.shop;
//
//import com.elitesland.sale.api.dto.BipItemSkuPriceDTO;
//import com.elitesland.sale.api.vo.param.shop.*;
//import com.elitesland.sale.api.vo.resp.shop.*;
//import com.elitesland.sale.api.vo.save.shop.*;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//
//import java.io.File;
//import java.math.BigDecimal;
//import java.util.List;
//
///**
// * 商品管理服务接口
// *
// * @author Shadow
// * @since 2021-08-10 15:45:56
// */
//public interface BipItemMngService {
//
//    /**
//     * 商品保存
//     *
//     * @param saveVO 商品信息
//     * @return 商品ID
//     */
//    ApiResult<Long> save(BipItemSaveVO saveVO);
//
//    /**
//     * 商品修改
//     *
//     * @param id       商品ID
//     * @param updateVO 商品信息
//     * @return 商品ID
//     */
//    ApiResult<Long> update(Long id, BipItemUpdateVO updateVO);
//
//    /**
//     * 批量立即更新上下架
//     *
//     * @param ids     商品ID
//     * @param onShelf 是否是上架，false表示下架
//     * @return 商品ID
//     */
//    ApiResult<List<Long>> updateShelf(List<Long> ids, boolean onShelf);
//
//    /**
//     * 批量定时上架
//     *
//     * @param shelfSaveVO 上架信息
//     * @return 商品ID
//     */
//    ApiResult<List<Long>> updateOnShelfTiming(BipItemShelfOnSaveVO shelfSaveVO);
//
//    /**
//     * 批量定时下架
//     *
//     * @param shelfSaveVO 下架信息
//     * @return 商品ID
//     */
//    ApiResult<List<Long>> updateOffShelfTiming(BipItemShelfOffSaveVO shelfSaveVO);
//
//    /**
//     * 定时任务执行的定时上架
//     *
//     * @param id 商品ID
//     * @return 商品ID
//     */
//    ApiResult<Long> updateOnShelfByTask(Long id);
//
//    /**
//     * 定时任务执行的定时下架
//     *
//     * @param id 商品ID
//     * @return 商品ID
//     */
//    ApiResult<Long> updateOffShelfByTask(Long id);
//
//    /**
//     * 更新审批结果
//     *
//     * @param approveSaveVO 审批结果
//     * @return 商品ID
//     */
//    ApiResult<List<Long>> updateApprove(BipItemApproveSaveVO approveSaveVO);
//
//    /**
//     * 调整最小起订量
//     *
//     * @param limitBuySaveVO 最小起定量信息
//     * @return 商品ID
//     */
//    ApiResult<List<Long>> updateLimitBuy(BipItemLimitBuySaveVO limitBuySaveVO);
//
//    /**
//     * 修改商品库存
//     *
//     * @param id              商品ID
//     * @param stockSaveVOList 库存记录
//     * @return 商品ID
//     */
//    ApiResult<Long> updateSkuStock(Long id, List<BipItemStockSaveVO> stockSaveVOList);
//
//    /**
//     * 更新商品销量
//     *
//     * @param id    商品ID
//     * @param num   总销量
//     * @param num90 90天销量
//     * @return 商品ID
//     */
//    ApiResult<Long> updateSale(Long id, Long num, Long num90);
//
//    /**
//     * 更新商品评价
//     *
//     * @param id       商品ID
//     * @param numTotal 评价总数
//     * @param numGood  好评数
//     * @return 商品ID
//     */
//    ApiResult<Long> updateEval(Long id, Long numTotal, Long numGood);
//
//    /**
//     * 更新商品评价
//     *
//     * @param id        商品ID
//     * @param evalScore 分值
//     * @return 商品ID
//     */
//    ApiResult<Long> updateEvalScore(Long id, BigDecimal evalScore);
//
//    /**
//     * 检查商品库存是否足够
//     *
//     * @param id 商品ID
//     * @return 是否足够
//     */
//    ApiResult<Boolean> executeCheckStock(Long id);
//
//    /**
//     * 删除商品
//     *
//     * @param id 商品ID
//     * @return 商品ID
//     */
//    ApiResult<Long> delete(Long id);
//
//    /**
//     * 删除商品
//     *
//     * @param ids 商品ID
//     * @return 商品ID
//     */
//    ApiResult<List<Long>> delete(List<Long> ids);
//
//    /**
//     * 商品获取详细信息
//     *
//     * @param id 商品ID
//     * @return 商品信息
//     */
//    ApiResult<BipItemDetailRespVO> get(Long id);
//
//    /**
//     * 获取商品的SKU信息
//     *
//     * @param id 商品ID
//     * @return SKU信息
//     */
//    ApiResult<List<BipItemSkuRespVO>> getSku(Long id);
//
//    /**
//     * 获取库存
//     *
//     * @param skuId SKU id
//     * @return 是否充足
//     */
//    ApiResult<Integer> getStockBySku(Long skuId);
//
//    /**
//     * 根据SKU的ID获取商品ID
//     *
//     * @param skuId skuId
//     * @return 商品ID
//     */
//    ApiResult<Long> getIdBySkuId(Long skuId);
//
//    /**
//     * 查询商品单位转换关系
//     *
//     * @param itemIds 商品中心的商品ID
//     * @return 转换关系
//     */
//    ApiResult<List<BipItemUomConvertRespVO>> queryItemUomConvert(List<Long> itemIds);
//
//    /**
//     * 查询待上架商品列表
//     *
//     * @param queryParamVO 查询参数
//     * @return 待上架商品列表
//     */
//    ApiResult<PagingVO<BipItemToShelfRespVO>> queryForToShelf(BipItemToShelfQueryParamVO queryParamVO);
//
//    /**
//     * 查询需要审核的商品
//     * <p>
//     * 包含上下架
//     *
//     * @param queryParamVO 查询参数
//     * @return 待审批的商品列表
//     */
//    ApiResult<PagingVO<BipItemApproveRespVO>> queryForApprove(BipItemApproveQueryParamVO queryParamVO);
//
//    /**
//     * 查询已上架商品列表
//     *
//     * @param queryParamVO 查询参数
//     * @return 已上架商品列表
//     */
//    ApiResult<PagingVO<BipItemOnShelfRespVO>> queryForOnShelf(BipItemOnShelfQueryParamVO queryParamVO);
//
//    /**
//     * 查询已下架商品列表
//     *
//     * @param queryParamVO 查询参数
//     * @return 已下架商品列表
//     */
//    ApiResult<PagingVO<BipItemOffShelfRespVO>> queryForOffShelf(BipItemOffShelfQueryParamVO queryParamVO);
//
//    /**
//     * 商品查询
//     *
//     * @param queryParam 查询参数
//     * @return 商品信息
//     */
//    ApiResult<PagingVO<BipItemQueryRespVO>> query(BipItemQueryParamVO queryParam);
//
//    /**
//     * 根据商品编码查询商品
//     *
//     * @param ouId         所属公司ID
//     * @param categoryCode 分类编码
//     * @return 商品信息
//     */
//    ApiResult<List<BipItemQueryRespVO>> queryByCategory(Long ouId, String categoryCode, Boolean onShelf);
//
//    /**
//     * 事件价格变更专用
//     * @param id skuId
//     * @param price 价格
//     * @param priceOld 旧价格
//     */
//    void updatePrice(Long id, BigDecimal price, BigDecimal priceOld);
//
//    /**
//     * 批量关联商品图片
//     * @param file jie
//     * @param ouCode
//     */
//    void handleImage(File file, String ouCode);
//
//}
//
//
