package com.elitesland.sale.api.vo.resp.pri;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/28 6:59 下午
 */
@ApiModel(description = "价格信息")
@Data
public class PriSalePriceDetailVO implements Serializable {
    private static final long serialVersionUID = 1730216271622112196L;

    @ApiModelProperty(value = "公司Id")
    private Long ouId;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;
    @ApiModelProperty(value = "商品编号")
    private String itemCode;
    @ApiModelProperty(value = "商品名称")
    private String itemName;
    @ApiModelProperty(value = "商品条码")
    private String barcode;
    @ApiModelProperty(value = "商品规格/型号")
    private String itemSpec;
    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "市场价")
    private BigDecimal marketPrice;
    @ApiModelProperty(value = "指导价")
    private BigDecimal guidePrice;
    @ApiModelProperty(value = "销售底价")
    private BigDecimal floorPrice;

    @ApiModelProperty(value = "对外基础价格")
    private BigDecimal basePrice;
    @ApiModelProperty(value = "客户价格")
    private BigDecimal custPrice;
    @ApiModelProperty(value = "客户等级价格")
    private BigDecimal custGroupPrice;
    @ApiModelProperty(value = "内部结算价格")
    private BigDecimal crossPrice;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;
    @ApiModelProperty(value = "税率描述")
    private String taxRateDesc;
    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "货币码")
    private String currCode;
    @ApiModelProperty(value = "币种名称")
    private String currName;

    @ApiModelProperty(value = "价格类型 [UDC]PRI:SALE_PRICE_TYPE")
    @SysCode(sys = "PRI", mod = "SALE_PRICE_TYPE")
    private String priceType;
    private String priceTypeName;

    @ApiModelProperty(value = "生效时间")
    private LocalDateTime validFrom;
    @ApiModelProperty(value = "失效时间")
    private LocalDateTime validTo;

    //活动价格添加
    @ApiModelProperty(value = "备注")
    private String remark;

    // 活动价格新增
    @ApiModelProperty(value = "活动价生效日期")
    private LocalDateTime promDateF;

    @ApiModelProperty(value = "活动价失效日期")
    private LocalDateTime promDateT;

    @ApiModelProperty("活动含税价格")
    private BigDecimal promotionPrice;

    @ApiModelProperty("活动不含税价格")
    private BigDecimal promotionNetPrice;

}
