package com.elitesland.sale.api.vo.param.sal;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @auther JinXK
 * @date 2021/7/7 14:32
 */
@Data
@ApiModel(description = "客户对账单分页查询入参")
public class SalSoaPageParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 7581921061490710634L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "对账单号")
    private String docNo;

    @ApiModelProperty(value = "对账日期-start")
    private LocalDateTime soaDateStart;

    @ApiModelProperty(value = "对账日期-end")
    private LocalDateTime soaDateEnd;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "申请人姓名")
    private String applyName;

    @ApiModelProperty(value = "对账单状态")
    private String soaStatus;

    @ApiModelProperty(value = "对账单收款状态[UDC]SAL:SOA_RECEIPT_STATUS")
    private String soaReceiptStatus;

    @ApiModelProperty(value = "对账单开票状态[UDC]SAL:SOA_INV_STATUS")
    private String soaInvStatus;

    @ApiModelProperty(value = "发货单编号")
    private String doDocNo;

    @ApiModelProperty(value = "销售订单编号")
    private String soNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "导出按钮标记")
    private String exportMark;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;

}
