package com.elitesland.sale.api.vo.param.taskinfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录
 */
@Data
@ApiModel(description = "执行记录")
public class ExecutRecordQueryParam extends AbstractOrderQueryParam {
    @ApiModelProperty(value = "唯一id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("执行记录编码")
    private String code;

    @ApiModelProperty("任务编码")
    private String taskCode;

    @ApiModelProperty("任务id")
    private Long taskId;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("任务类型")
    private String taskType;

    @ApiModelProperty("发布人")
    private String publishUser;

    @ApiModelProperty("发布人id")
    private Long publishUserId;

    @ApiModelProperty("发布人code")
    private String publishUserCode;

    @ApiModelProperty("状态")
    private String state;

    @ApiModelProperty("执行人")
    private String executUser;

    @ApiModelProperty("执行人id")
    private Long executUserId;

    @ApiModelProperty("执行人code")
    private String executUserCode;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("业务")
    private Long businessId;

    @ApiModelProperty("业务编码")
    private String businessCode;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("审核内容")
    private String auditDesc;

}