package com.elitesland.sale.api.vo.param.pri;

import com.elitescloud.cloudt.common.base.param.AbstractExportQueryParam;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 请求参数 - 价格分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 2:13 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "价格分页查询请求参数")
public class PriSalePricePagingParam extends AbstractExportQueryParam implements Serializable {
    private static final long serialVersionUID = 955965543378950852L;

    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    private List<Long> itemIds;

    @ApiModelProperty(value = "品项名称")
    private String itemName;

    @ApiModelProperty(value = "品项品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "生效时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validFromStart;

    @ApiModelProperty(value = "生效时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validFromEnd;

    @ApiModelProperty(value = "失效时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validToStart;

    @ApiModelProperty(value = "失效时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validToEnd;

    @ApiModelProperty(value = "区域")
    private String saleRegion;

    @ApiModelProperty(value = "价格类型")
    private String priceType;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "客户等级")
    private String custGroup;

    private Long custId;

    private List<Long> custIds;

    @ApiModelProperty(value = "价格状态 有效:ACTIVE 无效:INACTIVE")
    private String priceStatus;

    @ApiModelProperty("有效：true  无效：false")
    private Boolean priceStatus2;

}
