package com.elitesland.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.xiaoymin.knife4j.annotations.Ignore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import springfox.documentation.annotations.ApiIgnore;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-08-11 13:14
 */
@Data
@ApiModel(description = "意见反馈VO")
public class BipFeedBackRespVO implements Serializable {

    private static final long serialVersionUID = -4050930227124300422L;

    @ApiModelProperty("意见ID")
    private Long id;
    @ApiModelProperty("账户ID")
    private String custAccountId;

    @ApiModelProperty("账户名称")
    private String custAccountName;

    @ApiModelProperty("账户绑定手机号")
    private String tel;

    @ApiModelProperty("是否已回复")
    @SysCode(sys = "yst-supp", mod = "YESNO")
    private String replay;
    private String replayName;

    @ApiModelProperty("回复者id")
    private String replayAccountId;

    @ApiModelProperty("回复者名称")
    private String replayAccountName;

    @ApiModelProperty("回复内容")
    private String replayContext;

    @ApiModelProperty("回复时间")
    private LocalDateTime replayTime;

    @ApiModelProperty("顾客意见内容")
    private String context;

    @ApiModelProperty("提出时间")
    private LocalDateTime createTime;
    @ApiModelProperty("意见反馈图片--list")
    private List<String> fileCodeList;
    @ApiModelProperty("意见反馈图片--string")
    private String fileCodes;
}
