package com.elitesland.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 赠品(BipItem)实体类
 *
 * @author Shadow
 * @since 2021-08-10 15:48:24
 */

@Data
@ApiModel(description = "商品保存信息")
public class BipItemSaveVO implements Serializable {
    private static final long serialVersionUID = -97373875650435052L;

    @ApiModelProperty(value = "一级商品分类ID", required = true, position = 2)
    @NotNull(message = "一级商品分类为空")
    private Long categoryId1;

    @ApiModelProperty(value = "一级商品分类名称", required = true, position = 2)
    private String categoryName1;

    @ApiModelProperty(value = "二级商品分类ID", required = true, position = 3)
    @NotNull(message = "二级商品分类为空")
    private Long categoryId2;

    @ApiModelProperty(value = "二级商品分类名称", required = true, position = 3)
    private String categoryName2;

    @ApiModelProperty(value = "三级商品分类ID", required = true, position = 4)
    @NotNull(message = "三级商品分类为空")
    private Long categoryId3;

    @ApiModelProperty(value = "三级商品分类名称", required = true, position = 4)
    private String categoryName3;

    @ApiModelProperty(value = "商品ID", required = true, position = 5)
    @NotNull(message = "未知商品")
    private Long itemId;

    @ApiModelProperty(value = "商品编码", required = true, position = 5)
    @NotBlank(message = "商品编码为空")
    @Size(min = 1, max = 64, message = "商品编码的长度限制为64")
    private String itemCode;

    @ApiModelProperty(value = "商品名称", required = true, position = 5)
    @NotBlank(message = "商品名称为空")
    @Size(min = 1, max = 128, message = "商品名称的长度限制为128")
    private String itemName;

    @ApiModelProperty(value = "所属公司ID", required = true, position = 6)
    @NotNull(message = "未知所属公司")
    private Long ouId;

    @ApiModelProperty(value = "所属公司编码", position = 6)
    private String ouCode;

    @ApiModelProperty(value = "所属公司名称", required = true, position = 6)
    @NotBlank(message = "所属公司名称为空")
    @Size(min = 1, max = 128, message = "商品名称的长度限制为128")
    private String ouName;

    @ApiModelProperty(value = "商品SKU列表", required = true, position = 7)
    @NotEmpty(message = "商品SKU列表为空")
    @Valid
    private List<BipItemSkuSaveVO> skuList;

    @ApiModelProperty(value = "商品规格型号列表", position = 7)
    @Valid
    private List<BipItemSpecSaveVO> specList;

    @ApiModelProperty(value = "商品图片列表", required = true, position = 8)
    private List<BipItemPicSaveVO> picList;

    @ApiModelProperty(value = "商品单位", position = 10)
    private String unit;

    @ApiModelProperty(value = "商品标题", required = true, position = 11)
    @NotBlank(message = "商品标题为空")
    @Size(min = 1, max = 256, message = "商品标题的长度限制为256")
    private String title;

    @ApiModelProperty(value = "运费收费方式 - 是否包邮", required = true, position = 12)
    @NotNull(message = "运费收费方式为空")
    private Boolean fareFree;

    @ApiModelProperty(value = "运费模板ID", position = 13)
    private Long fareTmplId;

    @ApiModelProperty(value = "运费模板编号", position = 13)
    @Size(max = 64, message = "运费模板编号的长度限制为64")
    private String fareTmplCode;

    @ApiModelProperty(value = "运费模板名称", position = 13)
    @Size(max = 128, message = "运费模板名称的长度限制为128")
    private String fareTmplName;

    @ApiModelProperty(value = "商品的图文列表", position = 14)
    private List<BipItemPicContentSaveVO> contentPicList;
}
