package com.elitesland.tms.api.importentity;


import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadStyle;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 快递对账导入
 * @author huangyumiao
 * @date 2021/2/26
 */
@HeadStyle(fillForegroundColor = 22)
/**
 * 标题字体大小，是否加粗
 */
@HeadFontStyle(fontHeightInPoints = 13, bold = false)
@Data
@ApiModel(value = "导入快递对账", description = "导入快递对账")
public class TmsAccountCheckExcelImport {


    @ExcelProperty(value = "快递公司编号")
    @ApiModelProperty("快递公司编号")
    String logisticsOuCode;


    @ExcelProperty(value = "快递公司")
    @ApiModelProperty("快递公司")
    String logisticsOuName;


    @ExcelProperty(value = "快递单号")
    @ApiModelProperty("快递单号")
    String logisticsDocNo;


    @ExcelProperty(value = "物流费用")
    @ApiModelProperty("物流费用")
    BigDecimal logisticsFeeOu;


    @ExcelProperty(value = "系统运费")
    @ApiModelProperty("系统运费")
    private BigDecimal systemFreight;


    @ExcelProperty(value = "所属公司")
    @ApiModelProperty("所属公司")
    String theirOuCode;


    @ExcelProperty(value = "所属公司名称")
    @ApiModelProperty("所属公司名称")
    String theirOuName;

    @ApiModelProperty("审核状态")
    String auditStatus;

    @ApiModelProperty("物流费用-系统计算")
    BigDecimal logisticsFeeSys;

    @ApiModelProperty("结算状态")
    String clearingStatus;

    @ApiModelProperty("店铺编号")
    String storeCode;

    @ApiModelProperty("店铺名称")
    String storeName;



    @ApiModelProperty("系统发货时间")
    private LocalDateTime sysDeliverTime;

    @ApiModelProperty("重量")
    @ExcelProperty(value = "重量")
    Double weightOu;

    @ApiModelProperty("重量-系统订单")
    Double weightSys;

    @ApiModelProperty("误差费用")
    BigDecimal deviationFee;

    @ApiModelProperty("系统单据类型")
    String sysDocType;

    @ExcelProperty(value = "系统发货单号")
    @ApiModelProperty("系统发货单号")
    String sysDocNo;

    @ExcelProperty(value = "行号")
    @ApiModelProperty("行号")
    String lineNo;

    @ExcelProperty(value = "备注")
    @ApiModelProperty("备注")
    String remark;
}
