package com.elitesland.tms.api.provider;

import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitesland.tms.api.Application;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + TmsProvider.PATH)
public interface TmsProvider {
    String PATH = "/tms";

    @PostMapping("/findTmsOuList")
    ApiResult<List<TmsOuRespVO>> findTmsOuList(@RequestBody TmsOuQueryParamVO tmsOuQueryParamVO);

}
