package com.elitesland.tms.api.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 销售发货单发货结果返回对象
 *
 * @author fred
 * @since 2021-06-09 11:32:18
 */

@Data
@ApiModel(value = "SalDoShipRespVO", description = "销售发货单发货结果返回对象")
public class SalDoShipRespVO implements Serializable {

    private static final long serialVersionUID = -2204793804765767162L;

    /**
     * 发货成功的单号集合
     */
    @ApiModelProperty("发货成功的单号集合")
    private List<String> successList;
    /**
     * 发货失败的单号集合
     */
    @ApiModelProperty("发货失败的单号集合")
    private List<String> failList;
    /**
     * 回传物流信息失败的单号集合
     */
    @ApiModelProperty("回传物流信息失败的单号集合")
    private List<String> failList2;
    /**
     * 发货失败的信息提示
     */
    @ApiModelProperty("发货失败的信息提示")
    private String failMsg;

}