package com.elitesland.tms.api.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import java.time.LocalDateTime;

/**
 * @author huangyumiao
 * @date 2021/2/8
 */
@Data
public class BaseModelVO {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @CreatedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @CreatedDate
    private LocalDateTime createTime = LocalDateTime.now();

    @LastModifiedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @LastModifiedDate
    private LocalDateTime modifyTime = LocalDateTime.now();

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;
    /**
     * 操作人姓名
     */
    @ApiModelProperty("操作人姓名")
    private String operUserName;
}
