package com.elitesland.tms.api.vo;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;

/**
 * @author huangyumiao
 * @date 2021/2/26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "tms_account_check", description = "快递对账输出结果对象")
public class TmsAccountCheckRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -240233721171866866L;

    @ApiModelProperty("快递单号")
    String logisticsDocNo;

    @ApiModelProperty("快递对账名称")
    String logisticsOuName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商id")
    private Long suppId;
    @ApiModelProperty("供应商编码")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    String suppName;

    @ApiModelProperty("快递对账编码")
    String logisticsOuCode;

    @ApiModelProperty("审核时间")
    LocalDateTime auditTime;

    @ApiModelProperty("审核状态")
    String auditStatus;

    @ApiModelProperty("审核状态中文")
    String auditStatusName;

    @ApiModelProperty("物流费用-快递公司")
    BigDecimal logisticsFeeOu;

    @ApiModelProperty("物流费用-系统计算")
    BigDecimal logisticsFeeSys;

    @ApiModelProperty("系统运费")
    private BigDecimal systemFreight;



    @ApiModelProperty("结算状态")
    String clearingStatus;

    @ApiModelProperty("结算状态中文")
    String clearingStatusName;

    @ApiModelProperty("店铺编号")
    String storeCode;

    @ApiModelProperty("店铺名称")
    String storeName;

    @ApiModelProperty("所属公司编号")
    String theirOuCode;

    @ApiModelProperty("所属公司名称")
    String theirOuName;

    @ApiModelProperty("拼接 公司编号-供应商id")
    String suppIdAndTheirOuCode;

    @ApiModelProperty("系统单据类型")
    String sysDocType;

    @ApiModelProperty("系统单据类型-中文")
    String sysDocTypeName;

    @ApiModelProperty("系统单据号")
    String sysDocNo;

    @ApiModelProperty("系统发货时间")
    LocalDateTime sysDeliverTime;

    @ApiModelProperty("重量-快递对账")
    Double weightOu;
    @ApiModelProperty("重量-快递对账（+单位）")
    String weightOuStr;

    @ApiModelProperty("重量-系统订单")
    Double weightSys;
    @ApiModelProperty("重量-系统订单（+单位）")
    String weightSysStr;

    @ApiModelProperty("误差费用")
    BigDecimal deviationFee;

    @ApiModelProperty("记录创建者")
    String creator;

    @ApiModelProperty("采购订单号")
    String purDocNo;

    public String getWeightOuStr() {
        if (weightOu != null) {
            return getWeightOu() + "kg";
        }
        return "0kg";
    }

    public String getWeightSysStr() {
        if (weightSys != null) {
            return getWeightSys() + "kg";
        }
        return "0kg";
    }

    public BigDecimal getLogisticsFeeOu() {
        if (logisticsFeeOu != null) {
            return logisticsFeeOu.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return null;
    }

    public BigDecimal getLogisticsFeeSys() {
        if (logisticsFeeSys != null) {
            return logisticsFeeSys.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return null;
    }

    public BigDecimal getDeviationFee() {
        if (deviationFee != null) {
            return deviationFee.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return null;
    }

    public Double getWeightOu() {
        if (weightOu != null) {
            return BigDecimal.valueOf(weightOu).setScale(2, RoundingMode.HALF_UP).doubleValue();
        }
        return weightOu;
    }

    public Double getWeightSys() {
        if (weightSys != null) {
            return  BigDecimal.valueOf(weightSys).setScale(2, RoundingMode.HALF_UP).doubleValue();
        }
        return weightSys;
    }
}
