package com.elitesland.tms.api.vo;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2023/12/19 2:56 下午
 * @version:v1.0
 */
@Data
public class TmsKuaidiSubscribeVO {

    /**
     * 收件人或寄件人的手机号或固话（顺丰单号必填，也可以填写后四位，如果是固话，请不要上传分机号）
     */
    private String phone;

    /**
     * 订阅的快递公司的编码，一律用小写字母（com.elitesland.tms.api.constant.CompanyConstant）
     */
    @NotEmpty(message = "公司不可为空")
    private String company;

    /**
     * 订阅的快递单号，单号的最大长度是32个字符
     */
    @NotNull(message = "快递单号不可为空")
    private String number;





}
