package com.elitesland.tms.api.vo;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;


/**
 * 快递公司查询对象
 *
 * @author huangyumiao
 * @date 2021/2/26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "tms_account_check", description = "快递对账查询条件")
public class TmsAccountCheckParamVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 3187012280894306905L;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;

    @ApiModelProperty("快递公司名称")
    private String logisticsOuName;

    @ApiModelProperty("所属公司")
    private String theirOuCode;

    @ApiModelProperty("快递公司编码")
    private String logisticsOuCode;

    @ApiModelProperty("快递单号")
    private String logisticsDocNo;

    @ApiModelProperty("导入时间从")
    private LocalDateTime createTimeToStart;

    @ApiModelProperty("导入时间从至")
    private LocalDateTime createTimeToEnd;

    @ApiModelProperty("系统单据号")
    private String sysDocNo;

    @ApiModelProperty("系统单据类型")
    private List<String> sysDocType;

    @ApiModelProperty("审核状态集合")
    private List<String> auditStatus;

    @ApiModelProperty("结算状态集合")
    private List<String> clearingStatus;

    @ApiModelProperty("采购订单号")
    private String purDocNo;

}