package com.elitesland.tms.api.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author huangyumiao
 * @date 2021/2/25
 */
@Data
public class TmsAccountCheckSaveVO implements Serializable {


    private static final long serialVersionUID = -1120073765783237218L;

    @Id
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("记录创建者")
    String creator;

    @CreatedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @CreatedDate
    private LocalDateTime createTime = LocalDateTime.now();

    @LastModifiedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @LastModifiedDate
    private LocalDateTime modifyTime = LocalDateTime.now();

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;

    @ApiModelProperty("快递单号")
    String logisticsDocNo;

    @ApiModelProperty("快递公司名称")
    String logisticsOuName;

    @ApiModelProperty("快递公司编码")
    String logisticsOuCode;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核状态")
    String auditStatus;

    @ApiModelProperty("物流费用-快递公司")
    BigDecimal logisticsFeeOu;

    @ApiModelProperty("物流费用-系统计算")
    BigDecimal logisticsFeeSys;

    @ApiModelProperty("结算状态")
    String clearingStatus;

    @ApiModelProperty("店铺编号")
    String storeCode;

    @ApiModelProperty("店铺名称")
    String storeName;

    @ApiModelProperty("所属公司编号")
    String theirOuCode;

    @ApiModelProperty("所属公司名称")
    String theirOuName;

    @ApiModelProperty("系统单据类型")
    String sysDocType;

    @ApiModelProperty("系统单据号")
    String sysDocNo;

    @ApiModelProperty("系统发货时间")
    private LocalDateTime sysDeliverTime;


    @ApiModelProperty("重量-快递公司")
    Double weightOu;

//    @ApiModelProperty("重量-系统订单")
//    Double weightSys;

    @ApiModelProperty("误差费用")
    BigDecimal deviationFee;

    @ApiModelProperty("系统运费")
    private BigDecimal systemFreight;

}
