package com.elitesland.tms.api.vo;

import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;


/**
 * 功能说明 :TmsKuadiDetail
 *
 * @author hu
 * @date 2023-12-20 10:58:33
 */
@Data
public class TmsKuadiDetailVO extends BaseModelVO implements Serializable {
private static final long serialVersionUID =8166617993084768467L;

	/**
	 * 单号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "单号")
	private String nu;

	/**
	 * mas_id
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "mas_id")
    @JsonSerialize(using = ToStringSerializer.class)
	private Long masId;

	/**
	 * 流转时间
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "流转时间")
	private LocalDateTime time;

	/**
	 * 物流状态
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "物流状态")
	private String status;

	/**
	 * 快递信息
	 */
	@ApiModelProperty(value = "快递节点信息")
	private String context;

	/**
	 * 快递单当前状态
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "快递单当前状态")
	private String state;

	/**
	 * 地区编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "地区编码")
	private String areaCode;

	/**
	 * 地区名称
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "地区名称")
	private String areaName;


}
