package com.elitesland.tms.api.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import com.elitescloud.cloudt.common.annotation.SysCode;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author huangyumiao
 * @date 2021/3/2
 */
@Data
public class TmsLogisticsInfoRespVO  implements Serializable {

    private static final long serialVersionUID = 4141617664590631340L;

    private String id;

    @ApiModelProperty("快递单号")
    private String logisticsDocNo;

    @ApiModelProperty("快递公司")
    private String logisticsOuName;

    @ApiModelProperty("快递公司")
    private String logisticsOuCode;

    @ApiModelProperty("店铺编号")
    private String storeCode;

    @ApiModelProperty("店铺名称")
    private String storeName;

    @ApiModelProperty("平台订单号")
    private String docNo2;

    @ApiModelProperty("发货单编号")
    private String docNo;


    @ApiModelProperty("发货单状态 [UDC]SAL:DO_STATUS")
    @SysCode(sys = "yst-order", mod = "DO_STATUS")
    private String status;
    @ApiModelProperty("发货单状态名称")
    private String statusName;


    @ApiModelProperty("快递状态 [UDC]SAL:KUAIDI_100_STATE")
    @SysCode(sys = "yst-tms", mod = "KUAIDI_100_STATE")
    private String kuaidiStatus;
    @ApiModelProperty("快递状态名称")
    private String kuaidiStatusName;

    @ApiModelProperty("收货人")
    private String custContactName;

    @ApiModelProperty("手机号码")
    private String phone;
    @ApiModelProperty("收货国家")
    private String recvCountry;
    @ApiModelProperty("收货省份")
    private String recvProvince;
    @ApiModelProperty("收货省份Name")
    private String recvProvinceName;
    @ApiModelProperty("城市(编号/ID)")
    private String recvCity;
    @ApiModelProperty("城市名称")
    private String recvCityName;
    @ApiModelProperty("区县(编号/ID)")
    private String recvCounty;
    @ApiModelProperty("区县名称")
    private String recvCountyName;
    @ApiModelProperty("收货地址拼接")
    private String recvAddress;
    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("创建日期")
    private LocalDate docDate;

    @ApiModelProperty("创建人")
    private String docCreator;

    @ApiModelProperty("销售单号")
    private String relateDocNo;

    @ApiModelProperty("销售区域 [UDC]SAL:SAL_REGION")
    private String saleRegion;
    @ApiModelProperty("销售区域名称")
    private String saleRegionName;

}
