package com.elitesland.tms.api.vo;


import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;


/**
 * @author huangyumiao
 * @date 2021/2/8
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "tmsOuPageParamVO", description = "快递公司查询条件")
public class TmsOuPageParamVO extends AbstractOrderQueryParam {

    @ApiModelProperty("状态")
    private String logisticsOuStatus;

    @ApiModelProperty("快递公司编号")
    private String logisticsOuCode;

    @ApiModelProperty("快递公司编号")
    private List<String> logisticsOuCodes;

    @ApiModelProperty("快递公司名称")
    private String logisticsName;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;


}