package com.elitesland.tms.api.vo;



import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @date 2021/2/28
 * @author huangyumiao
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "tms_ou", description = "快递公司输出结果对象")
public class TmsOuRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -7122941521122772927L;

    @ApiModelProperty("快递公司编号")
    private String logisticsOuCode;

    @ApiModelProperty("快递公司名称")
    private String logisticsOuName;

    @ApiModelProperty("平台快递公司 [UDC]TMS:PAAS_LOGISTICS_OU_CODE")
    @SysCode(sys = "yst-tms", mod = "PAAS_LOGISTICS_OU_CODE")
    private String paasLogisticsOuCode;
    private String paasLogisticsOuCodeName;

    @ApiModelProperty("平台快递公司 中文")
    private String paasLogisticsOuName;

    @ApiModelProperty("联系人")
    private String contPerson;

    @ApiModelProperty("手机号码")
    private String mobile;

    @ApiModelProperty("联系电话")
    private String contactTel;

    @ApiModelProperty("邮编")
    private String postcode;

    @ApiModelProperty("详细地址")
    private String detailAddress;

    @ApiModelProperty("状态 [UDC]TMS:LOGISTICS_OU_STATUS")
    @SysCode(sys = "yst-tms", mod = "STATUS_ACTIVEORNO")
    private String logisticsOuStatus;
    @ApiModelProperty("状态中文")
    private String logisticsOuStatusName;

    /**
     * 暂挂时间
     */
    @ApiModelProperty("创建日期")
    private LocalDateTime holdTime;
    /**
     * 采购员员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("创建人")
    private Long agentEmpId;

    @ApiModelProperty("记录创建者")
    private String creator;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商id")
    private Long suppId;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;


}
