package com.elitesland.tms.api.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Id;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @date 2021/2/8
 * @author huangyumiao
 */
@Data
public class TmsOuUpdateVO implements Serializable {

    private static final long serialVersionUID = 3062578572146911468L;
    @Id
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @CreatedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @CreatedDate
    private LocalDateTime createTime = LocalDateTime.now();

    @LastModifiedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @LastModifiedDate
    private LocalDateTime modifyTime = LocalDateTime.now();

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;

    @ApiModelProperty("快递公司名称")
    String logisticsOuName;

    @ApiModelProperty("平台快递公司 [udc]tms:paas_logistics_ou_code")
    String paasLogisticsOuCode;

    @ApiModelProperty("联系人")
    String contPerson;

    @ApiModelProperty("手机号码")
    String mobile;

    @ApiModelProperty("联系电话")
    String contactTel;

    @ApiModelProperty("邮编")
    String postcode;

    @ApiModelProperty("详细地址")
    String detailAddress;

    @ApiModelProperty("记录创建者")
    String creator;

    @ApiModelProperty("供应商id")
    private Long suppId;
}
