/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.api.internal.parser.xml;

import com.aliyun.api.AliyunResponse;
import com.aliyun.api.internal.mapping.Converter;
import com.aliyun.api.internal.mapping.Converters;
import com.taobao.api.ApiException;
import com.taobao.api.internal.mapping.Reader;
import com.taobao.api.internal.util.XmlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

public class XmlConverter
implements Converter {
    @Override
    public <T extends AliyunResponse> T toResponse(String rsp, Class<T> clazz) throws ApiException {
        Element root = XmlUtils.getRootElementFromString(rsp);
        return (T)((AliyunResponse)this.getModelFromXML(root, clazz));
    }

    private <T> T getModelFromXML(final Element element, Class<T> clazz) throws ApiException {
        if (element == null) {
            return null;
        }
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                Element childE = XmlUtils.getChildElement(element, (String)name);
                return childE != null;
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return XmlUtils.getChildElementValue(element, (String)name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws ApiException {
                Element childE = XmlUtils.getChildElement(element, (String)name);
                if (childE != null) {
                    return XmlConverter.this.getModelFromXML(childE, type);
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws ApiException {
                ArrayList<String> list = null;
                Element listE = XmlUtils.getChildElement(element, (String)listName);
                if (listE != null) {
                    list = new ArrayList<String>();
                    List<Element> itemEs = XmlUtils.getChildElements(listE, (String)itemName);
                    for (Element itemE : itemEs) {
                        Object obj = null;
                        String value = XmlUtils.getElementValue(itemE);
                        if (String.class.isAssignableFrom(subType)) {
                            obj = value;
                        } else if (Long.class.isAssignableFrom(subType)) {
                            obj = Long.valueOf(value);
                        } else if (Integer.class.isAssignableFrom(subType)) {
                            obj = Integer.valueOf(value);
                        } else if (Boolean.class.isAssignableFrom(subType)) {
                            obj = Boolean.valueOf(value);
                        } else if (Date.class.isAssignableFrom(subType)) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            try {
                                obj = format.parse(value);
                            }
                            catch (ParseException e) {
                                throw new ApiException(e);
                            }
                        } else {
                            obj = XmlConverter.this.getModelFromXML(itemE, subType);
                        }
                        if (obj == null) continue;
                        list.add((String)obj);
                    }
                }
                return list;
            }
        });
    }
}

