/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame;

import com.taobao.api.internal.toplink.embedded.websocket.BufferManager;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.FrameHeader;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.EnumSet;

public abstract class FrameParser {
    private volatile State state = State.DONE;
    private FrameHeader header;
    private BufferManager bufferManager = new BufferManager();

    protected State transitionTo(State to) {
        if (this.state.canTransitionTo(to)) {
            State old = this.state;
            this.state = to;
            return old;
        }
        throw new IllegalStateException("Couldn't transtion from " + this.state + " to " + to);
    }

    protected State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame parse(ByteBuffer downloadBuffer) throws WebSocketException {
        ByteBuffer buffer = null;
        try {
            if (State.DONE.equals((Object)this.state)) {
                this.transitionTo(State.HEADER);
                buffer = downloadBuffer;
            } else {
                buffer = this.bufferManager.getBuffer(downloadBuffer);
            }
            if (State.HEADER.equals((Object)this.state)) {
                int position = buffer.position();
                this.header = this.createFrameHeader(buffer);
                if (this.header == null) {
                    buffer.position(position);
                    this.bufferManager.storeFragmentBuffer(buffer);
                    Frame frame = null;
                    return frame;
                }
                if (this.header.getContentsLength() - 1L > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("large data is not support yet");
                }
                this.transitionTo(State.FRAME);
            }
            if (State.FRAME.equals((Object)this.state)) {
                if (this.header.getContentsLength() > (long)buffer.remaining()) {
                    this.bufferManager.storeFragmentBuffer(buffer);
                    Frame position = null;
                    return position;
                }
                byte[] bodyBuf = new byte[(int)this.header.getContentsLength()];
                buffer.get(bodyBuf, 0, bodyBuf.length);
                Frame frame = this.createFrame(this.header, bodyBuf);
                this.transitionTo(State.DONE);
                this.bufferManager.init();
                this.header = null;
                Frame frame2 = frame;
                return frame2;
            }
            Frame frame = null;
            return frame;
        }
        finally {
            if (buffer != null && buffer != downloadBuffer) {
                downloadBuffer.position(downloadBuffer.limit() - buffer.remaining());
            }
        }
    }

    protected abstract FrameHeader createFrameHeader(ByteBuffer var1);

    protected abstract Frame createFrame(FrameHeader var1, byte[] var2);

    static enum State {
        HEADER,
        FRAME,
        DONE;

        private static EnumMap<State, EnumSet<State>> stateMap;

        boolean canTransitionTo(State state) {
            EnumSet<State> set = stateMap.get((Object)this);
            if (set == null) {
                return false;
            }
            return set.contains((Object)state);
        }

        static {
            stateMap = new EnumMap(State.class);
            stateMap.put(HEADER, EnumSet.of(FRAME));
            stateMap.put(FRAME, EnumSet.of(DONE));
            stateMap.put(DONE, EnumSet.of(HEADER));
        }
    }
}

