package com.taobao.api.internal.parser.xml;

import com.elitesland.yst.wms.connector.client.api.YstWmsResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoParser;
import com.taobao.api.internal.mapping.Converter;

public class QimenXmlParser<T extends YstWmsResponse> implements TaobaoParser<T> {

	private Class<T> clazz;

	public QimenXmlParser(Class<T> clazz) {
		this.clazz = clazz;
	}

	public T parse(String rsp, String responseType) throws ApiException {
		Converter converter = new XmlConverter(responseType);
		return converter.toResponse(rsp, clazz);
	}

	public Class<T> getResponseClass() {
		return clazz;
	}

}
