package com.elitesland.yst.wms.connector.client.api.request;

import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.TtxCustomerResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * TOP API: taobao.qimen.stockout.create request
 * 
 * @author top auto create
 * @since 1.0, 2024.01.09
 */
@Data
public class CustomerRequest extends YstWmsRequest<TtxCustomerResponse> {
    /**
     * 资料类型：1-供应商、2-客户、3-承运商、4-货主
     */
    @ApiModelProperty("资料类型：1-供应商、2-客户、3-承运商、4-货主")
    @NotBlank(message = "资料类型不能为空")
    private Integer type;

    /**
     * 编码
     */
    @ApiModelProperty("编码")
    @NotBlank(message = "编码不能为空")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty("名称")
    @NotBlank(message = "名称不能为空")
    private String name;

    /**
     * 国家
     */
    @ApiModelProperty("国家")
    private String country;

    /**
     * 省
     */
    @ApiModelProperty("省")
    private String state;

    /**
     * 市
     */
    @ApiModelProperty("市")
    private String city;

    /**
     * 区/县
     */
    @ApiModelProperty("区/县")
    private String district;

    /**
     * 乡镇
     */
    @ApiModelProperty("乡镇")
    private String town;

    /**
     * 地址1
     */
    @ApiModelProperty("地址1")
    private String address1;

    /**
     * 地址2
     */
    @ApiModelProperty("地址2")
    private String address2;

    /**
     * 联系人
     */
    @ApiModelProperty("联系人")
    private String attentionTo;

    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String phoneNum;

    /**
     * 手机
     */
    @ApiModelProperty("手机")
    private String mobile;

    /**
     * 传真
     */
    @ApiModelProperty("传真")
    private String faxNum;

    /**
     * 电子邮箱
     */
    @ApiModelProperty("电子邮箱")
    private String email;

    /**
     * 同步使用的仓库ZY_WX_001,ZY_CQ_001
     */
    @ApiModelProperty("同步使用的仓库ZY_WX_001,ZY_CQ_001")
    private String warehouseCode;

    /**
     * 货主（供应商和客户必传）【2025-08-20日新增字段】
     */
    @ApiModelProperty("货主（供应商和客户必传）【2025-08-20日新增字段】")
    private String companyCode;

    @Override
    public String getApiMethodName() {
        return "wms.globalCustomer.update";
    }

    @Override
    public Class<TtxCustomerResponse> getResponseClass() {
        return TtxCustomerResponse.class;
    }
}