package com.elitesland.yst.wms.connector.client.api.request;

import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.InventorySynchronizeResponse;
import com.taobao.api.ApiRuleException;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * TOP API: taobao.qimen.inventory.synchronize request
 *
 * @author top auto create
 * @since 1.0, 2023.04.21
 */
@Data
public class TtxInventorySynchronizeRequest extends YstWmsRequest<InventorySynchronizeResponse> {
    /**
     * 库存调整头信息
     */
    @ApiModelProperty("库存调整头信息")
    private AdjustHeader adjustHeader;

    /**
     * 需要调整的明细状态(查询调整库存的条件,条件越多查询的数据越精确)
     */
    @ApiModelProperty("需要调整的明细状态(查询调整库存的条件,条件越多查询的数据越精确)")
    private List<AdjustDetail> adjustDetails;

    /**
     * 目标明细状态(调整的目标状态、属性，数量)
     */
    @ApiModelProperty("目标明细状态(调整的目标状态、属性，数量)")
    private List<TargetAdjustDetail> targetAdjustDetails;

    @Override
    public String getApiMethodName() {
        return "ttx.inventory.synchronize";
    }


    @Override
    public Class<InventorySynchronizeResponse> getResponseClass() {
        return InventorySynchronizeResponse.class;
    }


    /**
     * 库存调整头信息
     */
    @Data
    public static class AdjustHeader implements Serializable {

        /**
         * 单号
         */
        @ApiModelProperty("单号")
        @NotBlank(message = "单号不能为空")
        private String code;

        /**
         * 调整类型：4-库存状态调整，8-属性调整
         */
        @ApiModelProperty("调整类型：4-库存状态调整，8-属性调整")
        @NotNull(message = "调整类型不能为空")
        private Integer adjustType;

        /**
         * 仓库编码 ZY_WX_001:知原无锡仓 ZY_CQ_001:知原重庆仓
         */
        @ApiModelProperty("仓库编码 ZY_WX_001:知原无锡仓 ZY_CQ_001:知原重庆仓")
        @NotBlank(message = "仓库编码不能为空")
        private String warehouseCode;

        /**
         * 货主编码
         */
        @ApiModelProperty("货主编码")
        @NotBlank(message = "货主编码不能为空")
        private String companyCode;
    }

    /**
     * 需要调整的明细状态(查询调整库存的条件,条件越多查询的数据越精确)
     */
    @Data
    public static class AdjustDetail implements Serializable {

        /**
         * 货品编码
         */
        @ApiModelProperty("货品编码")
        @NotBlank(message = "货品编码不能为空")
        private String itemCode;

        /**
         * 库存状态;DJ-待检、HG-合格、BHG不合格
         */
        @ApiModelProperty("库存状态;DJ-待检、HG-合格、BHG不合格")
        @NotBlank(message = "库存状态不能为空")
        private String inventorySts;

        /**
         * 批号
         */
        @ApiModelProperty("批号")
        private String lot;

        /**
         * 批次
         */
        @ApiModelProperty("批次")
        private String batch;

        /**
         * 过期日期
         */
        @ApiModelProperty("过期日期")
        private String expirationDate;

        /**
         * 生产日期
         */
        @ApiModelProperty("生产日期")
        private String manufactureDate;

        /**
         * 入库日期
         */
        @ApiModelProperty("入库日期")
        private String agingDate;
    }

    /**
     * 目标明细状态(调整的目标状态、属性，数量)
     */
    @Data
    public static class TargetAdjustDetail implements Serializable {

        /**
         * 货品编码
         */
        @ApiModelProperty("货品编码")
        @NotBlank(message = "货品编码不能为空")
        private String itemCode;

        /**
         * 调整数量
         */
        @ApiModelProperty("调整数量")
        @NotNull(message = "调整数量不能为空")
        private BigDecimal adjustQty;

        /**
         * 库存状态;DJ-待检、HG-合格、BHG不合格
         */
        @ApiModelProperty("库存状态;DJ-待检、HG-合格、BHG不合格")
        private String inventorySts;

        /**
         * 批号
         */
        @ApiModelProperty("批号")
        private String lot;

        /**
         * 批次
         */
        @ApiModelProperty("批次")
        private String batch;

        /**
         * 过期日期
         */
        @ApiModelProperty("过期日期")
        private String expirationDate;

        /**
         * 生产日期
         */
        @ApiModelProperty("生产日期")
        private String manufactureDate;

        /**
         * 入库日期
         */
        @ApiModelProperty("入库日期")
        private String agingDate;
    }
}
