/*
 * Decompiled with CFR 0.152.
 */
package com.qimencloud.api;

import com.qimencloud.api.QimenCloudClient;
import com.qimencloud.api.QimenCloudRequest;
import com.qimencloud.api.QimenCloudResponse;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoParser;
import com.taobao.api.internal.dto.RequestDTO;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.parser.xml.ObjectXmlParser;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoLogger;

public class DefaultQimenCloudClient
extends DefaultTaobaoClient
implements QimenCloudClient {
    public DefaultQimenCloudClient(String serverUrl, String appKey, String appSecret) {
        super(serverUrl, appKey, appSecret);
    }

    public DefaultQimenCloudClient(String serverUrl, String format) {
        super(serverUrl, null, null, format);
    }

    public DefaultQimenCloudClient(String serverUrl, String appKey, String appSecret, String format) {
        super(serverUrl, appKey, appSecret, format);
    }

    public DefaultQimenCloudClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
    }

    public DefaultQimenCloudClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout, signMethod);
    }

    @Override
    public QimenCloudResponse execute(QimenCloudRequest request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public QimenCloudResponse execute(QimenCloudRequest request, String session) throws ApiException {
        RequestDTO requestDTO;
        RequestParametersHolder requestHolder;
        long start = System.currentTimeMillis();
        TaobaoParser<QimenCloudResponse> parser = this.buildParser(request);
        QimenCloudResponse tRsp = this.parseBody(parser, request, requestHolder = this.invokeApi(requestDTO = this.buildRequestDTO(request), session, start));
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logApiError(this.appKey, request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return tRsp;
    }

    private TaobaoParser<QimenCloudResponse> buildParser(QimenCloudRequest request) {
        TaobaoParser<QimenCloudResponse> parser = null;
        if (this.needEnableParser) {
            String realFormat = request.getTopApiFormat() != null ? request.getTopApiFormat() : this.format;
            String realResponseType = this.getRealResponseType(request.getTopApiFormat() != null ? request.getTopApiFormat() : this.format, request.getResponseType());
            parser = "xml".equals(realFormat) || "xml2".equals(realFormat) ? new ObjectXmlParser<QimenCloudResponse>(request.getResponseClass()) : (realResponseType != null && (realResponseType.equals("qimen1") || realResponseType.equals("qimen2")) ? new ObjectJsonParser<QimenCloudResponse>(request.getResponseClass(), true) : new ObjectJsonParser<QimenCloudResponse>(request.getResponseClass(), this.useSimplifyJson));
        }
        return parser;
    }

    private QimenCloudResponse parseBody(TaobaoParser<QimenCloudResponse> parser, QimenCloudRequest request, RequestParametersHolder requestHolder) throws ApiException {
        QimenCloudResponse tRsp;
        if (this.needEnableParser) {
            tRsp = parser.parse(requestHolder.getResponseBody(), this.getRealResponseType(this.format, request.getResponseType()));
            tRsp.setBody(requestHolder.getResponseBody());
            tRsp.setRequestUrl(requestHolder.getRequestUrl());
            tRsp.setHeaders(requestHolder.getResponseHeaders());
        } else {
            try {
                tRsp = request.getResponseClass().newInstance();
                tRsp.setBody(requestHolder.getResponseBody());
                tRsp.setRequestUrl(requestHolder.getRequestUrl());
                tRsp.setHeaders(requestHolder.getResponseHeaders());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        return tRsp;
    }

    private RequestDTO buildRequestDTO(QimenCloudRequest request) {
        RequestDTO requestDTO = new RequestDTO();
        requestDTO.setApiMethodName(request.getApiMethodName());
        requestDTO.setContentType(request.getContentType());
        requestDTO.setTextParams(request.getQueryParams());
        requestDTO.setBody(request.getBody());
        requestDTO.setHeaderMap(request.getHeaderMap());
        requestDTO.setTimestamp(request.getTimestamp());
        requestDTO.setTargetAppKey(request.getTargetAppKey());
        requestDTO.setFormat(request.getTopApiFormat());
        requestDTO.setApiVersion(request.getApiVersion());
        return requestDTO;
    }
}

