/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.tmc;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkerThreadPerfMon {
    private static final Log LOG = LogFactory.getLog(WorkerThreadPerfMon.class);
    private final ThreadLocal<Long> lastFinishHandleMsgTime = new ThreadLocal();
    private final ThreadLocal<Long> idleTime = new ThreadLocal();
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final ThreadLocal<Long> lastLogTime = new ThreadLocal();
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public void enable() {
        this.enabled.set(true);
    }

    public void disable() {
        this.enabled.set(false);
    }

    public void beforeFinishHandleMsg() {
        if (!this.enabled.get()) {
            return;
        }
        this.lastFinishHandleMsgTime.set(System.currentTimeMillis());
    }

    public void afterRetrieveMsgFromQueue() {
        try {
            Long lastFinishHandleMsgTimeVal;
            if (!this.enabled.get()) {
                return;
            }
            Long startTimeVal = this.startTime.get();
            if (startTimeVal == null) {
                startTimeVal = System.currentTimeMillis();
                this.startTime.set(startTimeVal);
            }
            if ((lastFinishHandleMsgTimeVal = this.lastFinishHandleMsgTime.get()) == null) {
                return;
            }
            long curTime = System.currentTimeMillis();
            long lastIdleTime = curTime - lastFinishHandleMsgTimeVal;
            Long idleTimeVal = this.idleTime.get();
            if (idleTimeVal == null) {
                idleTimeVal = 0L;
            }
            idleTimeVal = idleTimeVal + lastIdleTime;
            this.idleTime.set(idleTimeVal);
            Long lastLogTimeVal = this.lastLogTime.get();
            if (lastLogTimeVal == null || curTime - lastLogTimeVal > 1000L) {
                long totalTime = curTime - startTimeVal;
                double idlePercent = 1.0 - (double)idleTimeVal.longValue() / (double)totalTime;
                LOG.info((Object)String.format("%d,%.20f", curTime, idlePercent));
                this.lastLogTime.set(curTime);
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"afterRetrieveMsgFromQueue err", e);
        }
    }
}

