package com.elitesland.yst.wms.connector.client.api.request;

import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.EntryorderConfirmResponse;
import com.elitesland.yst.wms.connector.client.api.response.ExamResultResponse;
import com.taobao.api.ApiRuleException;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.internal.mapping.ApiListType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class ExamResultRequest extends YstWmsRequest<ExamResultResponse> {

    @ApiModelProperty("SCM到货通知单号")
    private String relateDocNo;

    @ApiModelProperty("SCM收货单号")
    private String receiptNo;

    @ApiModelProperty("公司编码(货主编码)")
    private String ouCode;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("员工编号(验收员)")
    private String qtEmpId;

    @ApiModelProperty("部门编码(验收部门)")
    private String buCode;

    @ApiModelProperty("wms验收单号")
    private String qtNo;

    @ApiModelProperty("验收明细信息")
    private List<ExamResultDetail> details;

    @Data
    public static class ExamResultDetail {

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("规格型号")
        private String spec;

        @ApiModelProperty("浓度规格")
        private String concSpec;

        @ApiModelProperty("条码")
        private String barcode;

        @ApiModelProperty("应验收数")
        private Double qty;

        @ApiModelProperty("已验收数(已验收数=拒收数+不合格数+合格数)")
        private Double qtQty;

        @ApiModelProperty("拒收数(没有填0)")
        private Double rejectQty;

        @ApiModelProperty("拒收原因")
        private String noReason;

        @ApiModelProperty("合格数")
        private Double okQty;

        @ApiModelProperty("不合格数(没有填0)")
        private Double noQty;

        @ApiModelProperty("单位")
        private Double uom;

        @ApiModelProperty("批次")
        private String lotNo;

        @ApiModelProperty("批次入库日期")
        private String recvDate;

        @ApiModelProperty("生产日期")
        private String manuDate;

        @ApiModelProperty("有效期至")
        private String expiredDate;

        @ApiModelProperty("生产厂家")
        private String manuFactory;

        @ApiModelProperty("批号")
        private String menuLotNo;

        @ApiModelProperty("批准文号/备案证号/注册证号")
        private String approvalNumber;

        @ApiModelProperty("产地")
        private String origin;

        @ApiModelProperty("剂型")
        private String dosageForm;
    }


    @Override
    public String getApiMethodName() {
        return null;
    }

    @Override
    public Class<ExamResultResponse> getResponseClass() {
        return ExamResultResponse.class;
    }


}