package com.elitesland.yst.wms.connector.util;

import com.taobao.api.internal.util.TaobaoHashMap;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 符合TAOBAO习惯的纯字符串字典结构。
 * 
 * @author carver.gu
 * @since 1.0, Sep 13, 2009
 */
public class YstHashMap extends TaobaoHashMap {

	private static final long serialVersionUID = -1277791390393392630L;

	public YstHashMap() {
		super();
	}

	public YstHashMap(Map<? extends String, ? extends String> m) {
		super(m);
	}
    public HashMap<String, String> getHashMap() {
		HashMap<String, String> map = new HashMap<String, String>();
		for (Map.Entry<String, String> entry : this.entrySet()) {
			map.put(entry.getKey(), entry.getValue());
		}
		return map;
	}
	public HashMap<String, String[]> getYstHashMap() {
		HashMap<String, String[]> map = new HashMap<String, String[]>();
		for (Map.Entry<String, String> entry : this.entrySet()) {
			map.put(entry.getKey(), new String[]{entry.getValue()});
		}
		return map;
	}



}
