package com.elitesland.yst.wms.connector.rpc;


import com.elitesland.yst.wms.connector.Application;
import com.elitesland.yst.wms.connector.client.YstWmsRequestClient;
import com.elitesland.yst.wms.connector.client.api.response.EntryorderConfirmResponse;
import com.elitesland.yst.wms.connector.dto.TtxEntryorderConfirmDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Validated
@FeignClient(name = Application.NAME, path = YstWmsRequestClient.PASSIVE_CALL_API_URL+ "/zyyy")
public interface ZyyyWmsCallBackProvider {

    @PostMapping("/entryorder/confirm")
    @ApiOperation("入库确认回调通知")
    EntryorderConfirmResponse entryOrderConfirm(@RequestBody TtxEntryorderConfirmDTO requestDto);

    @PostMapping("/test")
    @ApiOperation("获取指定Token")
    public String test(String test);

}
