package com.elitesland.yst.wms.connector.client.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;

import com.elitesland.yst.wms.connector.client.api.response.OrderSnReportResponse;

/**
 * TOP API: taobao.qimen.order.sn.report request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class OrderSnReportRequest extends YstWmsRequest<OrderSnReportResponse> {
	
	

	/** 
	* 当前页(从1开始)
	 */
	private Long currentPage;

	/** 
	* 扩展属性
	 */
	private Map extendProps;

	/** 
	* 商品列表
	 */
	private Items items;

	/** 
	* 单据列表
	 */
	private Order order;

	/** 
	* 每页记录的条数
	 */
	private Long pageSize;

	/** 
	* 总页数
	 */
	private Long totalPage;

	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public Long getCurrentPage() {
		return this.currentPage;
	}

	public void setExtendProps(Map extendProps) {
		this.extendProps = extendProps;
	}

	public Map getExtendProps() {
		return this.extendProps;
	}

	public void setItems(Items items) {
		this.items = items;
	}

	public Items getItems() {
		return this.items;
	}

	public void setOrder(Order order) {
		this.order = order;
	}

	public Order getOrder() {
		return this.order;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setTotalPage(Long totalPage) {
		this.totalPage = totalPage;
	}

	public Long getTotalPage() {
		return this.totalPage;
	}

	public String getApiMethodName() {
		return "taobao.qimen.order.sn.report";
	}

	public Class<OrderSnReportResponse> getResponseClass() {
		return OrderSnReportResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(currentPage, "currentPage");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(totalPage, "totalPage");
	}
	
	/**
 * 单据列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 单据编号
		 */
		@ApiField("orderCode")
		private String orderCode;
		/**
		 * 单据类型(JYCK=一般交易出库单;HHCK=换货出库;BFCK=补发出库;PTCK=普通出库单;DBCK=调拨出库;B2BCK=B2B出库;QTCK=其他出库;SCRK=生产入库;LYRK=领用入库;CCRK=残次品入库;CGRK=采购入库;B2BRK=B2B入库;DBRK=调拨入库;QTRK=其他入库;XTRK=销退入库;THRK=退货入库;HHRK=换货入库;CNJG=仓内加工单;CGTH=采购退货出库单;)
		 */
		@ApiField("orderType")
		private String orderType;
		/**
		 * 外部业务编码(消息ID;用于去重;ISV对于同一请求;分配一个唯一性的编码。用来保证因为网络等原因导致重复传输;请求不会被重复处理;条件必填;条件为一单需要多次确认时)
		 */
		@ApiField("outBizCode")
		private String outBizCode;
		/**
		 * 货主编码
		 */
		@ApiField("ownerCode")
		private String ownerCode;
		/**
		 * 仓库编码
		 */
		@ApiField("warehouseCode")
		private String warehouseCode;
	

	public String getOrderCode() {
			return this.orderCode;
		}
		public void setOrderCode(String orderCode) {
			this.orderCode = orderCode;
		}
		public String getOrderType() {
			return this.orderType;
		}
		public void setOrderType(String orderType) {
			this.orderType = orderType;
		}
		public String getOutBizCode() {
			return this.outBizCode;
		}
		public void setOutBizCode(String outBizCode) {
			this.outBizCode = outBizCode;
		}
		public String getOwnerCode() {
			return this.ownerCode;
		}
		public void setOwnerCode(String ownerCode) {
			this.ownerCode = ownerCode;
		}
		public String getWarehouseCode() {
			return this.warehouseCode;
		}
		public void setWarehouseCode(String warehouseCode) {
			this.warehouseCode = warehouseCode;
		}

}

	/**
 * 商品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Item {

	/**
		 * 商品编码
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 商品仓储系统编码
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 商品序列号
		 */
		@ApiField("sn")
		private String sn;
	

	public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getSn() {
			return this.sn;
		}
		public void setSn(String sn) {
			this.sn = sn;
		}

}

	/**
 * 商品列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Items {

	/**
		 * 商品信息
		 */
		@ApiField("item")
		private Item item;
	

	public Item getItem() {
			return this.item;
		}
		public void setItem(Item item) {
			this.item = item;
		}

}


}