package com.elitesland.yst.wms.connector.client.api;

import com.taobao.api.internal.util.TaobaoHashMap;
import io.swagger.annotations.ApiModelProperty;

/**
 * 奇门API请求包装类。
 * 
 * @author fengsheng
 * @since Jan 27, 2016
 * @param <T> 奇门API响应类
 */
public abstract class YstWmsRequest<T extends YstWmsResponse> {

	protected String customerId; // 客户ID号
	protected Long timestamp; // 请求时间戳
	protected String version = "2.0"; // API版本号 
	protected String testType; // 测试类型
	protected String body; // 请求body体
	protected TaobaoHashMap queryParams; // 自定义URL参数
//	protected String ystSysTenantCode;//yst系统租户编码
	private Long reqUserId; //请求用户ID
	private String reqUserName;//请求用户名称
	private String reqTrackingUuid;//请求链路

	@ApiModelProperty("业务参数,用于日志查询,如唯一单据编码或ID")
	private String businessParam; //业务参数,用于日志查询 扩展

	public String getBusinessParam() {
		return businessParam;
	}

	public void setBusinessParam(String businessParam) {
		this.businessParam = businessParam;
	}
	public Long getReqUserId() {
		return reqUserId;
	}

	public void setReqUserId(Long reqUserId) {
		this.reqUserId = reqUserId;
	}

	public String getReqUserName() {
		return reqUserName;
	}

	public void setReqUserName(String reqUserName) {
		this.reqUserName = reqUserName;
	}


//	public String getYstSysTenantCode() {
//		return ystSysTenantCode;
//	}
//
//	public void setYstSysTenantCode(String ystSysTenantCode) {
//		this.ystSysTenantCode = ystSysTenantCode;
//	}


	public String getCustomerId() {
		return this.customerId;
	}

	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public Long getTimestamp() {
		return this.timestamp;
	}

	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public String getVersion() {
		return this.version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getTestType() {
		return this.testType;
	}

	public void setTestType(String testType) {
		this.testType = testType;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getBody() {
		return this.body;
	}

	public TaobaoHashMap getQueryParams() {
		return this.queryParams;
	}

	public void addQueryParam(String key, String value) {
		if (this.queryParams == null) {
			this.queryParams = new TaobaoHashMap();
		}
		this.queryParams.put(key, value);
	}

	/**
	 * 获取API名称。
	 */
	public abstract String getApiMethodName();

	/**
	 * 获取API 名称描述。
	 */
//	public abstract String getApiMethodNameDescribe();

	/**
	 * 获取API 描述。
	 */
//	public abstract String getApiMethodDescribe();

	/**
	 * 获取API响应类实例。
	 */
	public abstract Class<T> getResponseClass();

}
