package com.elitesland.yst.wms.connector.client.api.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * TTX货品包装明细DTO
 */
@Data
@ApiModel("TTX货品包装明细DTO")
public class ItemPackingDetailDTO implements Serializable {
    /**
     * 货主编码
     */
    @ApiModelProperty(value = "货主编码", required = true, notes = "与globalItem.companyCode一致")
    @NotBlank(message = "货主编码不能为空")
    private String companyCode;

    /**
     * 货品编码
     */
    @ApiModelProperty(value = "货品编码", required = true, notes = "与globalItem.code一致")
    @NotBlank(message = "货品编码不能为空")
    private String itemCode;

    /**
     * 包装编码
     */
    @ApiModelProperty(value = "包装编码", notes = "与header.packingCode一致")
    private String packingCode;

    /**
     * 优先级
     */
    @ApiModelProperty(value = "优先级")
    private Integer sequence;

    /**
     * 单位编码
     */
    @ApiModelProperty(value = "单位编码", required = true, notes = "EA：基本包装、CS：中包装、PL：大包装")
    @NotBlank(message = "单位编码不能为空")
    private String unitCode;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称", required = true)
    @NotBlank(message = "单位名称不能为空")
    private String unitName;

    /**
     * 显示名称
     */
    @ApiModelProperty(value = "显示名称")
    private String displayName;

    /**
     * 数量比例
     */
    @ApiModelProperty(value = "数量比例", notes = "整数")
    private BigDecimal qtyRatio;

    /**
     * 单位数量
     */
    @ApiModelProperty(value = "单位数量", required = true, notes = "整数")
    private Integer unitQty;

    /**
     * 单位长度
     */
    @ApiModelProperty(value = "单位长度", notes = "cm，保留两位小数")
    private BigDecimal unitLength;

    /**
     * 单位宽度
     */
    @ApiModelProperty(value = "单位宽度", notes = "cm，保留两位小数")
    private BigDecimal unitWidth;

    /**
     * 单位高度
     */
    @ApiModelProperty(value = "单位高度", notes = "cm，保留两位小数")
    private BigDecimal unitHeight;

    /**
     * 单位体积
     */
    @ApiModelProperty(value = "单位体积", notes = "cm³，保留两位小数")
    private BigDecimal unitVolume;

    /**
     * 单位重量
     */
    @ApiModelProperty(value = "单位重量", notes = "kg，保留两位小数")
    private BigDecimal unitWeight;

    /**
     * 每层数量
     */
    @ApiModelProperty(value = "每层数量", notes = "默认0，整数")
    private Integer ti;

    /**
     * 层数
     */
    @ApiModelProperty(value = "层数", notes = "默认0，整数")
    private Integer hi;

    /**
     * 单位作为散装入库
     */
    @ApiModelProperty(value = "单位作为散装入库")
    private Integer unitAsLooseInbound;

    /**
     * 单位作为散装出库
     */
    @ApiModelProperty(value = "单位作为散装出库")
    private Integer unitAsLooseOutbound;

    /**
     * 同步至全局
     */
    @ApiModelProperty(value = "同步至全局", notes = "0-否；1-是（默认0）")
    private Integer syncGlobal;
}