package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CainiaoEndpointLockerTopOrderWithholdResponse;

/**
 * TOP API: cainiao.endpoint.locker.top.order.withhold request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.19
 */
public class CainiaoEndpointLockerTopOrderWithholdRequest extends BaseTaobaoRequest<CainiaoEndpointLockerTopOrderWithholdResponse> {
	
	

	/** 
	* 柜子公司编码
	 */
	private String companyCode;

	/** 
	* 扩展字段
	 */
	private String extra;

	/** 
	* 柜子id
	 */
	private String guiId;

	/** 
	* 运单号
	 */
	private String mailNo;

	/** 
	* 开放用户id
	 */
	private String openUserId;

	/** 
	* 柜子订单编码
	 */
	private String orderCode;

	/** 
	* 订单类型(0-取件业务，1-寄件业务，2-派样业务)
	 */
	private Long orderType;

	/** 
	* 代扣金额（全额），单位：分
	 */
	private Long totalFee;

	public void setCompanyCode(String companyCode) {
		this.companyCode = companyCode;
	}

	public String getCompanyCode() {
		return this.companyCode;
	}

	public void setExtra(String extra) {
		this.extra = extra;
	}

	public String getExtra() {
		return this.extra;
	}

	public void setGuiId(String guiId) {
		this.guiId = guiId;
	}

	public String getGuiId() {
		return this.guiId;
	}

	public void setMailNo(String mailNo) {
		this.mailNo = mailNo;
	}

	public String getMailNo() {
		return this.mailNo;
	}

	public void setOpenUserId(String openUserId) {
		this.openUserId = openUserId;
	}

	public String getOpenUserId() {
		return this.openUserId;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getOrderCode() {
		return this.orderCode;
	}

	public void setOrderType(Long orderType) {
		this.orderType = orderType;
	}

	public Long getOrderType() {
		return this.orderType;
	}

	public void setTotalFee(Long totalFee) {
		this.totalFee = totalFee;
	}

	public Long getTotalFee() {
		return this.totalFee;
	}

	public String getApiMethodName() {
		return "cainiao.endpoint.locker.top.order.withhold";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("company_code", this.companyCode);
		txtParams.put("extra", this.extra);
		txtParams.put("gui_id", this.guiId);
		txtParams.put("mail_no", this.mailNo);
		txtParams.put("open_user_id", this.openUserId);
		txtParams.put("order_code", this.orderCode);
		txtParams.put("order_type", this.orderType);
		txtParams.put("total_fee", this.totalFee);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoEndpointLockerTopOrderWithholdResponse> getResponseClass() {
		return CainiaoEndpointLockerTopOrderWithholdResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(companyCode, "companyCode");
		RequestCheckUtils.checkNotEmpty(guiId, "guiId");
		RequestCheckUtils.checkNotEmpty(mailNo, "mailNo");
		RequestCheckUtils.checkNotEmpty(openUserId, "openUserId");
		RequestCheckUtils.checkNotEmpty(orderCode, "orderCode");
		RequestCheckUtils.checkNotEmpty(orderType, "orderType");
		RequestCheckUtils.checkNotEmpty(totalFee, "totalFee");
	}
	

}