/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame.draft06;

import com.taobao.api.internal.toplink.embedded.websocket.frame.FrameHeader;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft06.FrameBuilderDraft06;
import java.nio.ByteBuffer;

public class FrameHeaderDraft06
implements FrameHeader {
    protected final long payloadLength;
    protected final FrameBuilderDraft06.PayloadLengthType payloadLengthType;
    protected final int headerLength;
    protected final boolean fragmented;
    protected final FrameBuilderDraft06.Opcode opcode;
    protected FrameBuilderDraft06.Opcode realOpcode;

    public FrameHeaderDraft06(boolean fragmented, int headerLength, FrameBuilderDraft06.PayloadLengthType payloadLengthType, long payloadLength, FrameBuilderDraft06.Opcode opcode) {
        this.headerLength = headerLength + payloadLengthType.offset();
        this.payloadLengthType = payloadLengthType;
        this.payloadLength = payloadLength;
        this.fragmented = fragmented;
        this.opcode = opcode;
    }

    public FrameHeaderDraft06(boolean fragmented, int headerLength, FrameBuilderDraft06.PayloadLengthType payloadLengthType, long payloadLength, FrameBuilderDraft06.Opcode opcode, FrameBuilderDraft06.Opcode realOpcode) {
        this.headerLength = headerLength + payloadLengthType.offset();
        this.payloadLengthType = payloadLengthType;
        this.payloadLength = payloadLength;
        this.fragmented = fragmented;
        this.opcode = opcode;
        this.realOpcode = realOpcode;
    }

    @Override
    public long getFrameLength() {
        return (long)this.headerLength + this.payloadLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    @Override
    public long getContentsLength() {
        return this.payloadLength;
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    public boolean isContinuation() {
        return FrameBuilderDraft06.Opcode.CONTINUATION.equals((Object)this.opcode);
    }

    public FrameBuilderDraft06.Opcode getOpcode() {
        return this.opcode;
    }

    public FrameBuilderDraft06.Opcode getRealOpcode() {
        return this.realOpcode;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(2 + this.payloadLengthType.offset());
        buf.put((byte)((this.fragmented ? 0 : 128) | this.opcode.intValue()));
        switch (this.payloadLengthType) {
            case LEN_SHORT: {
                buf.put((byte)this.payloadLength);
                break;
            }
            case LEN_16: {
                buf.put(this.payloadLengthType.byteValue());
                buf.putShort((short)this.payloadLength);
                break;
            }
            case LEN_63: {
                buf.put(this.payloadLengthType.byteValue());
                buf.putLong(this.payloadLength);
            }
        }
        buf.flip();
        return buf;
    }
}

