package com.elitesland.yst.wms.connector.client.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;

import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;

import com.elitesland.yst.wms.connector.client.api.response.DeliveryordersumQueryResponse;

/**
 * TOP API: taobao.qimen.deliveryordersum.query request
 * 
 * @author top auto create
 * @since 1.0, 2020.05.13
 */
public class DeliveryordersumQueryRequest extends YstWmsRequest<DeliveryordersumQueryResponse> {
	
	

	/** 
	* 复核时间
	 */
	private String checkTime;

	/** 
	* 出库结束时间
	 */
	private String deliveryEndTime;

	/** 
	* 出库开始时间
	 */
	private String deliveryStartTime;

	/** 
	* 订单下载结束时间
	 */
	private String downloadEndTime;

	/** 
	* 订单下载开始时间
	 */
	private String downloadStartTime;

	/** 
	* 货主编码，string（50）
	 */
	private String ownerCode;

	/** 
	* 当前页(必填)
	 */
	private String page;

	/** 
	* 每页显示条数(必填)
	 */
	private String pageSize;

	/** 
	* 支付结束时间
	 */
	private String payEndTime;

	/** 
	* 支付开始时间
	 */
	private String payStartTime;

	/** 
	* 订单来源平台编码, string (50) , 必填,TB= 淘宝 、TM=天猫 、JD=京东、DD=当当、PP=拍拍、YX=易讯、EBAY=ebay、QQ=QQ网购、AMAZON=亚马逊、SN=苏宁、GM=国美、WPH=唯品会、JM=聚美、LF=乐蜂、MGJ=蘑菇街、JS=聚尚、PX=拍鞋、YT=银泰、YHD=1号店、VANCL=凡客、YL=邮乐、YG=优购、1688=阿里巴巴、POS=POS门店、MIA=蜜芽、GW=商家官网、CT=村淘、YJWD=云集微店、OTHERS=其他,  (只传英文编码)
	 */
	private String sourcePlatformCode;

	/** 
	* 淘系非淘系
	 */
	private String sourceType;

	/** 
	* 仓库编码
	 */
	private String warehouseCode;

	public void setCheckTime(String checkTime) {
		this.checkTime = checkTime;
	}

	public String getCheckTime() {
		return this.checkTime;
	}

	public void setDeliveryEndTime(String deliveryEndTime) {
		this.deliveryEndTime = deliveryEndTime;
	}

	public String getDeliveryEndTime() {
		return this.deliveryEndTime;
	}

	public void setDeliveryStartTime(String deliveryStartTime) {
		this.deliveryStartTime = deliveryStartTime;
	}

	public String getDeliveryStartTime() {
		return this.deliveryStartTime;
	}

	public void setDownloadEndTime(String downloadEndTime) {
		this.downloadEndTime = downloadEndTime;
	}

	public String getDownloadEndTime() {
		return this.downloadEndTime;
	}

	public void setDownloadStartTime(String downloadStartTime) {
		this.downloadStartTime = downloadStartTime;
	}

	public String getDownloadStartTime() {
		return this.downloadStartTime;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setPage(String page) {
		this.page = page;
	}

	public String getPage() {
		return this.page;
	}

	public void setPageSize(String pageSize) {
		this.pageSize = pageSize;
	}

	public String getPageSize() {
		return this.pageSize;
	}

	public void setPayEndTime(String payEndTime) {
		this.payEndTime = payEndTime;
	}

	public String getPayEndTime() {
		return this.payEndTime;
	}

	public void setPayStartTime(String payStartTime) {
		this.payStartTime = payStartTime;
	}

	public String getPayStartTime() {
		return this.payStartTime;
	}

	public void setSourcePlatformCode(String sourcePlatformCode) {
		this.sourcePlatformCode = sourcePlatformCode;
	}

	public String getSourcePlatformCode() {
		return this.sourcePlatformCode;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public String getSourceType() {
		return this.sourceType;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.deliveryordersum.query";
	}

	public Class<DeliveryordersumQueryResponse> getResponseClass() {
		return DeliveryordersumQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(checkTime, "checkTime");
	}
	

}