package com.elitesland.yst.wms.connector.client.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;

import com.elitesland.yst.wms.connector.client.api.response.ItemlackQueryResponse;

/**
 * TOP API: taobao.qimen.itemlack.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.12
 */
public class ItemlackQueryRequest extends YstWmsRequest<ItemlackQueryResponse> {
	
	

	/** 
	* 出库单号
	 */
	private String deliveryOrderCode;

	/** 
	* 仓储系统出库单号
	 */
	private String deliveryOrderId;

	/** 
	* 扩展属性
	 */
	private Map extendProps;

	/** 
	* 货主编码
	 */
	private String ownerCode;

	/** 
	* 当前页(从1开始)
	 */
	private Long page;

	/** 
	* 每页orderLine条数(最多100条)
	 */
	private Long pageSize;

	/** 
	* 仓库编码
	 */
	private String warehouseCode;

	public void setDeliveryOrderCode(String deliveryOrderCode) {
		this.deliveryOrderCode = deliveryOrderCode;
	}

	public String getDeliveryOrderCode() {
		return this.deliveryOrderCode;
	}

	public void setDeliveryOrderId(String deliveryOrderId) {
		this.deliveryOrderId = deliveryOrderId;
	}

	public String getDeliveryOrderId() {
		return this.deliveryOrderId;
	}

	public void setExtendProps(Map extendProps) {
		this.extendProps = extendProps;
	}

	public Map getExtendProps() {
		return this.extendProps;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.itemlack.query";
	}

	public Class<ItemlackQueryResponse> getResponseClass() {
		return ItemlackQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(deliveryOrderCode, "deliveryOrderCode");
		RequestCheckUtils.checkMaxLength(deliveryOrderCode, 50, "deliveryOrderCode");
		RequestCheckUtils.checkMaxLength(deliveryOrderId, 50, "deliveryOrderId");
		RequestCheckUtils.checkMaxLength(ownerCode, 50, "ownerCode");
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkMaxLength(warehouseCode, 50, "warehouseCode");
	}
	

}