package com.elitesland.yst.wms.connector.client.api.request;

import java.util.List;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.StockoutCreateResponse;
import lombok.Data;

/**
 * TOP API: taobao.qimen.stockout.create request
 *
 * @author top auto create
 * @since 1.0, 2024.01.09
 */
@Data
public class StockoutCreateRequest extends YstWmsRequest<StockoutCreateResponse> {

    /**
     * 出库单信息
     */
    @ApiModelProperty("出库单信息")
    private DeliveryOrder deliveryOrder;

    /**
     * 扩展属性
     */
    @ApiModelProperty("扩展属性")
    private Map extendProps;

    /**
     * 奇门仓储字段,说明,string(50),,
     */
    @ApiModelProperty("奇门仓储字段,说明,string(50),,")
    private List<Item> items;

    /**
     * 单据信息
     */
    @ApiModelProperty("单据信息")
    private List<OrderLine> orderLines;

    public String getApiMethodName() {
        return "taobao.qimen.stockout.create";
    }

    public Class<StockoutCreateResponse> getResponseClass() {
        return StockoutCreateResponse.class;
    }

    public void check() throws ApiRuleException {
    }

    /**
     * 奇门仓储字段,说明,string(50),,
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class Batch {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String actualQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇仓储字段,说明,string(50),,")
        private String batchCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String expireDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String inventoryType;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String produceCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String productDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String quantity;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
    }

    /**
     * 奇门仓储字段,说明,string(50),,
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class PriceAdjustment {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String discount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String endDate;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String standardPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String startDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String type;
    }

    /**
     * 奇门仓储字段,说明,string(50),,
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class Item {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String actualAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String actualQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String adventLifecycle;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String amount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String approvalNumber;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String barCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String batchCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String batchRemark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private List<Batch> batchs;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String brandCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String brandName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String categoryId;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String categoryName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String changeTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String channelCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String color;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String costPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String defectiveQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String diffQuantity;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String discount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String discountPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String englishName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String exCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String expireDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String extCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String goodsCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String grossWeight;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String height;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String inventoryType;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isAreaSale;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isBatchMgmt;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isFragile;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isHazardous;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isSNMgmt;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isShelfLifeMgmt;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isSku;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemId;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemType;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String lackQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String latestUpdateTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String length;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String lockQuantity;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String lockupLifecycle;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String netWeight;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String normalQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderLineNo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderType;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String originAddress;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String originCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String outBizCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String ownerCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String packCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String packageMaterial;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String paperQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String pcs;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String planQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String price;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private PriceAdjustment priceAdjustment;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String pricingCategory;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String produceCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String productCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String productDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String purchasePrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String quantity;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String reason;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiveQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String referencePrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String rejectLifecycle;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String retailPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String safetyStock;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String seasonCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String seasonName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String shelfLife;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String shortName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String size;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String skuProperty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sn;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String snCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sourceOrderCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String standardPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String stockStatus;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String stockUnit;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String subSourceOrderCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String supplierCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String supplierName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String tagPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String tareWeight;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String tempRequirement;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String title;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String unit;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String volume;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String warehouseCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String width;
    }

    /**
     * 订单细节
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class Detail {

        /**
         * 订单项目
         */
        @ApiModelProperty("订单项目")
        private List<Item> items;
    }

    /**
     * 发票信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class Invoice {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String code;
        /**
         * 订单细节
         */
        @ApiModelProperty("订单细节")
        private Detail detail;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String invoiceAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String invoiceContent;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String invoiceHead;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String number;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String type;
    }

    /**
     * 订单信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class OrderLine {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String actualPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String actualQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String amount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String batchCode;
        /**
         * pici xinxi
         */
        @ApiModelProperty("pici xinxi")
        private List<Batch> batchs;
        /**
         * 品牌代码
         */
        @ApiModelProperty("品牌代码")
        private String brandCode;
        /**
         * brandName
         */
        @ApiModelProperty("brandName")
        private String brandName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String color;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String deliveryOrderId;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String discount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String discountAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String discountPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String exceptionQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String expireDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String extCode;
        /**
         * 订单信息扩展信息
         */
        @ApiModelProperty("订单信息扩展信息")
        private Map extendProps;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String inventoryType;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemId;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String locationCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String moveInLocation;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String moveOutLocation;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderLineNo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderSourceCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String outBizCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String ownerCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String payNo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String planQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String produceCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String productCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String productDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String purchasePrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String qrCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String quantity;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String referencePrice;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String retailPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String settlementAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String size;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String skuProperty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sourceOrderCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String standardAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String standardPrice;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String status;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String stockInQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String stockOutQty;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String subDeliveryOrderId;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String subSourceCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String subSourceOrderCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String taobaoItemCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String warehouseCode;
    }

    /**
     * 关联单据信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class RelatedOrder {

        /**
         * 关联的订单编号
         */
        @ApiModelProperty("关联的订单编号")
        private String orderCode;
        /**
         * 关联的订单类型(CG=采购单;DB=调拨单;CK=出库单;RK=入库单;只传英文编码)
         */
        @ApiModelProperty("关联的订单类型(CG=采购单;DB=调拨单;CK=出库单;RK=入库单;只传英文编码)")
        private String orderType;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
    }

    /**
     * 提货人信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class PickerInfo {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String area;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String birthDate;
        /**
         * 车牌号
         */
        @ApiModelProperty("车牌号")
        private String carNo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String career;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String city;
        /**
         * 公司名称
         */
        @ApiModelProperty("公司名称")
        private String company;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String countryCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String countryCodeCiq;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String countryCodeCus;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String detailAddress;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String email;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String fax;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String gender;
        /**
         * 证件号
         */
        @ApiModelProperty("证件号")
        private String id;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String idNumber;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String idType;
        /**
         * 移动电话
         */
        @ApiModelProperty("移动电话")
        private String mobile;
        /**
         * 姓名
         */
        @ApiModelProperty("姓名")
        private String name;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String nick;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String province;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverMobile;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverTel;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverZipCode;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 固定电话
         */
        @ApiModelProperty("固定电话")
        private String tel;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String town;
    }

    /**
     * 发件人信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class SenderInfo {

        /**
         * 区域
         */
        @ApiModelProperty("区域")
        private String area;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String birthDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String carNo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String career;
        /**
         * 城市
         */
        @ApiModelProperty("城市")
        private String city;
        /**
         * 公司名称
         */
        @ApiModelProperty("公司名称")
        private String company;
        /**
         * 国家二字码
         */
        @ApiModelProperty("国家二字码")
        private String countryCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String countryCodeCiq;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String countryCodeCus;
        /**
         * 详细地址
         */
        @ApiModelProperty("详细地址")
        private String detailAddress;
        /**
         * 电子邮箱
         */
        @ApiModelProperty("电子邮箱")
        private String email;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String fax;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String gender;
        /**
         * 证件号
         */
        @ApiModelProperty("证件号")
        private String id;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String idNumber;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String idType;
        /**
         * 移动电话
         */
        @ApiModelProperty("移动电话")
        private String mobile;
        /**
         * 姓名
         */
        @ApiModelProperty("姓名")
        private String name;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String nick;
        /**
         * 省份
         */
        @ApiModelProperty("省份")
        private String province;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverMobile;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverTel;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverZipCode;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 固定电话
         */
        @ApiModelProperty("固定电话")
        private String tel;
        /**
         * 村镇
         */
        @ApiModelProperty("村镇")
        private String town;
        /**
         * 邮编
         */
        @ApiModelProperty("邮编")
        private String zipCode;
    }

    /**
     * 收件人信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class ReceiverInfo {

        /**
         * 区域
         */
        @ApiModelProperty("区域")
        private String area;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String birthDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String carNo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String career;
        /**
         * 城市
         */
        @ApiModelProperty("城市")
        private String city;
        /**
         * 公司名称
         */
        @ApiModelProperty("公司名称")
        private String company;
        /**
         * 国家二字码
         */
        @ApiModelProperty("国家二字码")
        private String countryCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String countryCodeCiq;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String countryCodeCus;
        /**
         * 详细地址
         */
        @ApiModelProperty("详细地址")
        private String detailAddress;
        /**
         * 电子邮箱
         */
        @ApiModelProperty("电子邮箱")
        private String email;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String fax;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String gender;
        /**
         * 证件号
         */
        @ApiModelProperty("证件号")
        private String id;
        /**
         * 收件人证件号码
         */
        @ApiModelProperty("收件人证件号码")
        private String idNumber;
        /**
         * 收件人证件类型(1-身份证、2-军官证、3-护照、4-其他)
         */
        @ApiModelProperty("收件人证件类型(1-身份证、2-军官证、3-护照、4-其他)")
        private String idType;
        /**
         * 移动电话
         */
        @ApiModelProperty("移动电话")
        private String mobile;
        /**
         * 姓名
         */
        @ApiModelProperty("姓名")
        private String name;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String nick;
        /**
         * 省份
         */
        @ApiModelProperty("省份")
        private String province;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverMobile;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverTel;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiverZipCode;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 固定电话
         */
        @ApiModelProperty("固定电话")
        private String tel;
        /**
         * 村镇
         */
        @ApiModelProperty("村镇")
        private String town;
        /**
         * 邮编
         */
        @ApiModelProperty("邮编")
        private String zipCode;
    }

    /**
     * null
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class DeliveryRequirements {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String deliveryType;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String scheduleDay;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String scheduleEndTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String scheduleStartTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String scheduleType;
    }

    /**
     * 奇门仓储字段,说明,string(50),,
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class PackageMaterial {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String quantity;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String type;
    }

    /**
     * null
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class Package {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String expressCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String height;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String invoiceNo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private List<Item> items;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String length;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String logisticsCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String logisticsName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String packageCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private List<PackageMaterial> packageMaterialList;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String theoreticalWeight;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String volume;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String weight;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String width;
    }

    /**
     * 出库单信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class DeliveryOrder {

        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String actualAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String arAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String batchCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String businessMemo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String buyerMessage;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String buyerName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String buyerNick;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String buyerPhone;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String collectedAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String confirmType;
        /**
         * 出库单创建时间(YYYY-MM-DD HH:MM:SS)
         */
        @ApiModelProperty("出库单创建时间(YYYY-MM-DD HH:MM:SS)")
        private String createTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String declaredAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String deliveryNote;
        /**
         * 出库单号
         */
        @ApiModelProperty("出库单号")
        private String deliveryOrderCode;
        /**
         * null
         */
        @ApiModelProperty("null")
        private DeliveryRequirements deliveryRequirements;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String discountAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String exceptionCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String expressCode;
        /**
         * 出库单扩展信息
         */
        @ApiModelProperty("出库单扩展信息")
        private Map extendProps;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String fetchItemLocation;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String freight;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String gotAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String identifyCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String insuranceFlag;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String invoiceFlag;
        /**
         * 发票信息
         */
        @ApiModelProperty("发票信息")
        private List<Invoice> invoices;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isCod;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isPaymentCollected;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isUrgency;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String isValueDeclared;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemAmount;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String itemName;
        /**
         * 商品
         */
        @ApiModelProperty("商品")
        private List<Item> items;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String lineNumber;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String logisticsAreaCode;
        /**
         * 物流公司编码(SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通 、ZTO=中通(ZTO)、HTKY=百世汇通、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、OTHER=其他;只传英文编码)
         */
        @ApiModelProperty("物流公司编码(SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通 、ZTO=中通(ZTO)、HTKY=百世汇通、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、OTHER=其他;只传英文编码)")
        private String logisticsCode;
        /**
         * 物流公司名称(包括干线物流公司等)
         */
        @ApiModelProperty("物流公司名称(包括干线物流公司等)")
        private String logisticsName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String maxArrivalTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String mergeOrderCodes;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String mergeOrderFlag;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String minArrivalTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String modifiedTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String noStackTag;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String operateTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String operatorCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String operatorName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderConfirmTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderFlag;
        /**
         * 订单信息
         */
        @ApiModelProperty("订单信息")
        private List<OrderLine> orderLines;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderNote;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderSourceCode;
        /**
         * 出库单渠道类型,VIP=唯品会，FX=分销 ，SHOP=门店
         */
        @ApiModelProperty("出库单渠道类型,VIP=唯品会，FX=分销 ，SHOP=门店")
        private String orderSourceType;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String orderStatus;
        /**
         * 出库单类型(PTCK=普通出库单;DBCK=调拨出库;B2BCK=B2B出库;QTCK=其他出库;CGTH=采购退货出库单;XNCK=虚拟出库单, JITCK=唯品出库)
         */
        @ApiModelProperty("出库单类型(PTCK=普通出库单;DBCK=调拨出库;B2BCK=B2B出库;QTCK=其他出库;CGTH=采购退货出库单;XNCK=虚拟出库单, JITCK=唯品出库)")
        private String orderType;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String outBizCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String ownerCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String packCode;
        /**
         * null
         */
        @ApiModelProperty("null")
        private List<Package> packages;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String payMethod;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String payNo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String payTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String personalOrderNote;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String personalPackageNote;
        /**
         * 提货人信息
         */
        @ApiModelProperty("提货人信息")
        private PickerInfo pickerInfo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String placeOrderTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String planArrivalTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String planDeliveryDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String preDeliveryOrderCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String preDeliveryOrderId;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String presaleOrderType;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String price;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String priorityCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String produceDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String quantity;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String receiveOrderTime;
        /**
         * 收件人信息
         */
        @ApiModelProperty("收件人信息")
        private ReceiverInfo receiverInfo;
        /**
         * 到货时间(YYYY-MM-DD HH:MM:SS)
         */
        @ApiModelProperty("到货时间(YYYY-MM-DD HH:MM:SS)")
        private String receivingTime;
        /**
         * 关联单据信息
         */
        @ApiModelProperty("关联单据信息")
        private List<RelatedOrder> relatedOrders;
        /**
         * 备注
         */
        @ApiModelProperty("备注")
        private String remark;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String salesModel;
        /**
         * 要求出库时间(YYYY-MM-DD)
         */
        @ApiModelProperty("要求出库时间(YYYY-MM-DD)")
        private String scheduleDate;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sellerId;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sellerMessage;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sellerNick;
        /**
         * 发件人信息
         */
        @ApiModelProperty("发件人信息")
        private SenderInfo senderInfo;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String serviceCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String serviceFee;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String shelfLife;
        /**
         * 送货时间(YYYY-MM-DD HH:MM:SS)
         */
        @ApiModelProperty("送货时间(YYYY-MM-DD HH:MM:SS)")
        private String shippingTime;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String shopCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String shopName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sourceOrderCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sourcePlatformCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String sourcePlatformName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String status;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String storageFee;
        /**
         * 供应商编码
         */
        @ApiModelProperty("供应商编码")
        private String supplierCode;
        /**
         * 供应商名称
         */
        @ApiModelProperty("供应商名称")
        private String supplierName;
        /**
         * 关联的入库单号（ERP分配）
         */
        @ApiModelProperty("关联的入库单号（ERP分配）")
        private String targetEntryOrderCode;
        /**
         * 入库仓库编码, string (50) ，统仓统配等无需ERP指定仓储编码的情况填OTHER
         */
        @ApiModelProperty("入库仓库编码, string (50) ，统仓统配等无需ERP指定仓储编码的情况填OTHER")
        private String targetWarehouseCode;
        /**
         * 入库仓库名称, string (50)
         */
        @ApiModelProperty("入库仓库名称, string (50)")
        private String targetWarehouseName;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String totalAmount;
        /**
         * 单据总行数(当单据需要分多个请求发送时;发送方需要将totalOrderLines填入;接收方收到后;根据实际接收到的条数和totalOrderLines进行比对;如果小于;则继续等待接收请求。如果等于;则表示该单据的所有请求发送完成.)
         */
        @ApiModelProperty("单据总行数(当单据需要分多个请求发送时;发送方需要将totalOrderLines填入;接收方收到后;根据实际接收到的条数和totalOrderLines进行比对;如果小于;则继续等待接收请求。如果等于;则表示该单据的所有请求发送完成.)")
        private Long totalOrderLines;
        /**
         * 提货方式(到仓自提、快递、干线物流)
         */
        @ApiModelProperty("提货方式(到仓自提、快递、干线物流)")
        private String transportMode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String transpostSum;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String uomCode;
        /**
         * 奇门仓储字段,说明,string(50),,
         */
        @ApiModelProperty("奇门仓储字段,说明,string(50),,")
        private String warehouseAddressCode;
        /**
         * 仓库编码(统仓统配等无需ERP指定仓储编码的情况填OTHER)
         */
        @ApiModelProperty("仓库编码(统仓统配等无需ERP指定仓储编码的情况填OTHER)")
        private String warehouseCode;
        /**
         * 仓库名称
         */
        @ApiModelProperty("仓库名称")
        private String warehouseName;
    }
}
