package com.elitesland.yst.wms.connector.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author : chen.niu
 * @description : 回调请求参数
 * @date : 2025-03-25 15:28
 */
@Data
public class YstWmsCallBackRequestDTO {

    /**
     * 调用系统编码  需要和服务配置一致
     */
    @ApiModelProperty("源调用系统编码-平台配置颁发给wms")
    private String sourceSysCode;

    /**
     * 调用系统appKey 需要和服务配置一致
     */
    @ApiModelProperty("源调用系统appKey-平台配置颁发给wms")
    private String sourceAppKey;

    /**
     * 通知系统-系统编码
     */
    @ApiModelProperty("通知系统-系统编码")
    private String notifySysCode;

    /**
     * 通知系统-应用编码
     */
    @ApiModelProperty("通知系统-应用编码")
    private String notifyAppKey;

    /**
     * 通知系统-应用编码
     */
    @ApiModelProperty("通知系统-应用秘钥")
    private String notifyAppSecret;

    public YstWmsCallBackRequestDTO copy(){
        YstWmsCallBackRequestDTO ystWmsCallBackRequestDTO=new YstWmsCallBackRequestDTO();
        ystWmsCallBackRequestDTO.setSourceSysCode(sourceSysCode);
        ystWmsCallBackRequestDTO.setSourceAppKey(sourceAppKey);
        ystWmsCallBackRequestDTO.setNotifySysCode(notifySysCode);
        ystWmsCallBackRequestDTO.setNotifyAppKey(notifyAppKey);
        ystWmsCallBackRequestDTO.setNotifyAppSecret(notifyAppSecret);
        return ystWmsCallBackRequestDTO;
    }
    public void validateRequestDTO() {
        if (StringUtils.isBlank(sourceSysCode)) {
            throw new IllegalArgumentException("sourceSysCode cannot be null or empty");
        }
        if (StringUtils.isBlank(sourceAppKey)) {
            throw new IllegalArgumentException("sourceAppKey cannot be null or empty");
        }
        if (StringUtils.isBlank(notifySysCode)) {
            throw new IllegalArgumentException("notifySysCode cannot be null or empty");
        }
        if (StringUtils.isBlank(notifyAppKey)) {
            throw new IllegalArgumentException("notifyAppKey cannot be null or empty");
        }
        if (StringUtils.isBlank(notifyAppSecret)) {
            throw new IllegalArgumentException("notifyAppSecret cannot be null or empty");
        }
    }

//
//    /**
//     * 通知系统-租户编码
//     */
//    @ApiModelProperty("通知系统-租户编码")
//    private String notifyTenantCode;

}
